/***************************************************************************

     order.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTRACT_H
#define CONTRACT_H

#include <QString>
#include "../database/mdb.h"

/**
 * @class Contract model class
 * @short Contract model class
 *
 * Class provides functions and variables to work with
 * information about contracts
 *
 * @author Andrianov Pavel
 */
class Contract
{
public:
    /**
     * @brief Standart constructor of contract
     * Init of standart values in object contract
     * @return exit code
     */
    /// Standart constructor
    Contract();

    /**
     * @brief GetID
     * Get id by this contract
     * @return id integer
     */
    int getId();

    QString tableName();

    int getContractorId();

    QString getName();

    QString getType();

    QString getComment();

    Contract(Mdb* db, int id);
private:
    int id;
    int contractor_id;
    QString type;
    QString name;
    QString comment;

};

#endif // CONTRACT_H
