/***************************************************************************

     main.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include <QtCore/QCoreApplication>
/*
#include "src/model/order.h"
#include "src/database/mdb.h"
#include "src/model/good.h"
*/
//=====================================

#include <QApplication>
//#include <QLibrary>
#include <QDebug>
#include <QMainWindow>
#include <QObject>
#include <QPluginLoader>
#include <QtPlugin>

#if defined(Q_OS_LINUX)
#include <sys/utsname.h>
#endif

//Q_IMPORT_PLUGIN(gui_plugin)

 #include "src/user_interface/maemo/graphicsinterface.h"
#include "src/user_interface/maemo/imainwindow.h"

//=====================================

#include "src/business_logic/manager.h"

#include <QtGui>
#include <QObject>

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    qDebug() << "MAIN: Create manager";
    Manager* manager = new Manager();

    //=====================================

    /**
      *Plugin
      */

    QPluginLoader* qplPluginLoad;

    #if defined(Q_OS_LINUX)
        qplPluginLoad = new QPluginLoader(QDir::rootPath()+"/lib/libDemo.so");
        qDebug()<<QDir::rootPath()+"/lib/libDemo.so";
    #elif defined(Q_OS_MAC)
        app.exit();
        return 0;
    #elif defined(Q_OS_WIN)
        qplPluginLoad = new QPluginLoader(QDir::currentPath()+"/Demo.dll");
        //qplPluginLoad = new QPluginLoader("c:\Qt\trunk\mobile-trade\app\debug\Demo.dll");
        qDebug()<<QDir::currentPath();
    #endif

    qplPluginLoad->load();

    if(qplPluginLoad->isLoaded())
    {
        qDebug()<<"Plugin is Loaded";
        QObject *plugin = qplPluginLoad->instance();

        GraphicsInterface *interface = qobject_cast<GraphicsInterface*>( plugin );

        IMainWindow* wnd = interface->getMainWindow();

        QObject::connect(wnd,SIGNAL(clientGoodInfoOblectRegistered(GoodInfoObject*)),
                         manager,SLOT(registersObjectOnGoodInfo(GoodInfoObject*)));
        QObject::connect(wnd,SIGNAL(clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject*)),
                         manager,SLOT(registersObjectOnGoodViewInfo(GoodsViewInfoObject*)));
        QObject::connect(wnd,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)),
                         manager,SLOT(registersObjectOnPathInfo(PathInfoObject*)));
        QObject::connect(wnd,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)),
                         manager,SLOT(registersObjectOnServiceInfo(ServiceInfoObject*)));
        QString str = (QString)(interface->getName());

        qDebug() << str;

        wnd->show();

        /**
          *Test signal
          */
        //manager->goodsViewerOpened();
        //wnd2->createSignal(10);

    }
    else
    {
        qDebug()<<"Plugin don't found";
    }

    return app.exec();
}
