/***************************************************************************

     demoservicelogic.h
     -------------
     Copyright (c) 2010 by Zabirokhin Denis <denis.zabirokhin@gmail.com>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef DEMOSERVICELOGIC_H
#define DEMOSERVICELOGIC_H

#include<QObject>

/// Include view classes
#include <QStandardItemModel>
#include <QAbstractItemModel>

/// Include Model Classes
#include "../model/order.h"
#include "../model/good.h"
#include "../model/goodstree.h"

/// Include database and network subsystem
#include "../database/mdb.h"
//#include "../network/soapclient.h"

#define DEBUG 1

class DemoServiceLogic: public QObject
{
Q_OBJECT
private:
    soapclient *client;
    Mdb *db;
    GoodsTree *tmp_tree;
public:
    DemoServiceLogic();

public slots:
    /// Slots to send command to get data from demo web-service

    /// Get data functions
    void getGoods();
    void getContractors();
    void getSellPoints();
    void getOrders();
    void getPrice();
    void getPay();
    void getContracts();
    void getDiscount();
    void getDelivery();
    void getSellFirm();
    void getContractTypes();
    void getSampleOrderComment();
    void getGoodTypes();
    void getAll();

    /// Send data functions
    void sendOrder(int id, int contractorId, int sellpointId, QVector<Good> *goods);
    /// Slots to get data from web-service signals
    
    /// Update functions
    void updateGoods(QStandardItemModel*);
    void updateContractors(QStandardItemModel*);
    void updateSellPoints(QStandardItemModel*);
    void updateOrders(QStandardItemModel*);
    void updatePrice(QStandardItemModel*);
    void updatePay(QStandardItemModel*);
    void updateContracts(QStandardItemModel*);
    void updateDiscount(QStandardItemModel*);
    void updateDelivery(QStandardItemModel*);
    void updateSellFirm(QStandardItemModel*);
    void updateContractTypes(QStandardItemModel*);
    void updateSampleOrderComment(QStandardItemModel*);
    void updateGoodTypes(QStandardItemModel*);
    
    ///Slots to internal operations

    /// Get info source
    void getInfoSource();
    ///Slots to midleware operations
    /// Operations with objects Goods

    /// Show all goods from MDB
    void goodsView();

    /// If good selected
    void goodSelected(int id);

    /// Goods filter
    void goodsFiltered(QString filter);

    /// Good type selected
    void typeSelected(int id);

signals:
    ///Signals that object is ready
    /// Types of goods for goodsview are ready
    /**
     * This signal is emitted when update of types of goods
     * for goodsview table is ready
     * @param model a pointer for a model with data for goodsview
     */
    void typesReady(QAbstractItemModel* model);

    /// Goods for goodsview are ready
    /**
     * This signal is emitted when update of goods
     * for goodsview table is ready
     * @param model a pointer for a model with data for goodsview
     */
    void goodsReady(QAbstractItemModel* model);

    /// Path for goodsview path string are ready
    /**
     * This signal is emitted when update of path is ready
     * @param path path
     */
    void pathReady(QAbstractItemModel* path);

    /// Returns detailed info about good

    /// Returns Good name
    void goodDetailName(QString name);

    /// Returns quantity
    void goodDetailQuantity(QString count);

    /// Returns Good price
    void goodDetailPrice(QString price);

    /// Returns Good type name
    void goodDetailTypeName(QString name);

    /// Returns Good remains
    void goodDetailRemain(QString remain );

    /// Returns Good plan
    void goodDetailPlan(QString plan);

    /// Returns Good currency
    void goodDetailCurrency(QString currency);

    /// Data ready signals

    void dataReady(QAbstractItemModel* types, QAbstractItemModel* goods);

    /// Returns the name of the data source
    void dataSourceNameReady(QString data_source_name);

    ///Midlware signals to processing data

    ///Other signals
};

#endif // DEMOSERVICELOGIC_H
