#include "testSellPoint.h"
#include "../../src/model/sellpoint.h"
#include <QtTest/QtTest>
#define NAME_OF_FILE "../TestSellPoint.xml"
#define NAME_OF_CLASS "SellPoint"


void TestSellPoint::initTestCase()
{
    /*Opening the file*/
    QString fileName = QString(NAME_OF_FILE);
    QFile file(fileName);
    if(!file.open(QFile::ReadOnly | QFile::Text)) qDebug("Error in opening the file");
    /*retranslating it to Dom structure*/
    QString errorStr;
    int errorLine;
    int errorColumn;
    if(!domDocument.setContent(&file, true, &errorStr, &errorLine, &errorColumn))
    {
        qDebug(errorStr.toAscii());
        qDebug(QString("%1").arg(errorLine).toAscii());
        qDebug(QString("%1").arg(errorColumn).toAscii());
    }

    /*Moving to the root*/
    root = domDocument.documentElement();
    if (root.tagName() != NAME_OF_CLASS) qDebug(root.tagName().toAscii());

    sellPoint1 = new SellPoint();
    QCOMPARE(sellPoint1->getId(), NEW_ID);
    QVERIFY(sellPoint1 != 0 );
}

void TestSellPoint::cleanupTestCase()
{
    delete sellPoint1;
    sellPoint1 = 0;
    QVERIFY( sellPoint1 == 0);
}

void TestSellPoint::tableTestCase()
{
    QCOMPARE(sellPoint1->tableName(),QString("tblSellPoints"));
}

void TestSellPoint::getSetTestCase()
{
    testCase = root.firstChildElement("GetSetTestCase");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        /*Get parameters from xml*/
        parametr = simpleTest.firstChildElement("param");
        id = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        name = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        address = parametr.text();
        /*fulling object with data*/
        sellPoint1->setId(id);
        sellPoint1->setAddress(address);
        sellPoint1->setName(name);
        /*Checking*/
        QCOMPARE(sellPoint1->getId(), id);
        QCOMPARE(sellPoint1->getAddress(), address);
        QCOMPARE(sellPoint1->getName(), name);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}


void TestSellPoint::toQStringDoubleTestCase()
{
    testCase = root.firstChildElement("toQStringDoubleTest");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        /*Get parameters from xml*/
        toQStringQS = simpleTest.firstChildElement("param").text();
        toQStringD = toQStringQS.toDouble();
        /*Checking*/
        QCOMPARE(sellPoint1->toQString(toQStringD), toQStringQS);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}

void TestSellPoint::toQStringIntTestCase()
{
    testCase = root.firstChildElement("toQStringIntTest");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        /*Get parameters from xml*/
        toQStringQS = simpleTest.firstChildElement("param").text();
        toQStringI = toQStringQS.toInt();
        /*Checking*/
        QCOMPARE(sellPoint1->toQString(toQStringI), toQStringQS);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}
