#include "TestGood.h"
#include "../../src/model/good.h"
#include <QtTest/QtTest>
#define NAME_OF_FILE "../TestGood.xml"
#define NAME_OF_CLASS "TestGood"

void TestGood::initTestCase()
{
    /*Opening the file*/
    QString fileName = QString(NAME_OF_FILE);
    QFile file(fileName);
    if(!file.open(QFile::ReadOnly | QFile::Text)) qDebug("Error in opening the file");
    /*retranslating it to Dom structure*/
    QString errorStr;
    int errorLine;
    int errorColumn;
    if(!domDocument.setContent(&file, true, &errorStr, &errorLine, &errorColumn))
    {
        qDebug(errorStr.toAscii());
        qDebug(QString("%1").arg(errorLine).toAscii());
        qDebug(QString("%1").arg(errorColumn).toAscii());
    }

    /*Moving to the root*/
    root = domDocument.documentElement();
    if (root.tagName() != NAME_OF_CLASS) qDebug(root.tagName().toAscii());

    /*creating objects*/
    db = new Mdb();
    QVERIFY( db != 0 );
    good1 = new Good();
    QVERIFY( good1 != 0 );
}

void TestGood::cleanupTestCase()
{
    delete db;
    db=0;
    delete good1;
    good1 = 0;
    QVERIFY( db == 0 );
    QVERIFY( good1 == 0);
}

//void TestGood::TestInitialization()
//{
//    /*Moving to TestCase TestInitialization*/
//    testCase = root.firstChildElement("TestInitialization");
//    simpleTest = testCase.firstChildElement("Test");
//    while(!simpleTest.isNull()){
//        /*getting parameters from xml file*/
//        id = simpleTest.firstChildElement("param").text().toInt();
//        name = simpleTest.firstChildElement("param").text();
//        price = simpleTest.firstChildElement("param").text().toDouble();
//        remain = simpleTest.firstChildElement("param").text().toInt();
//        type = simpleTest.firstChildElement("param").text().toInt();
//        quantity= simpleTest.firstChildElement("param").text().toInt();
//        currencyid = simpleTest.firstChildElement("param").text().toInt();
//        /*Creating the object*/
//        good1 = new Good(id,name, address,phone);
//        /*Verifying*/
//     //   QCOMPARE(good1->getId(),id);
//        QCOMPARE(good1->getName(),name);
//        QCOMPARE(good1->getPrice(),price);
//        QCOMPARE(good1->getRemains(),remain);
//        QCOMPARE(good1->getType(),type);
//        QCOMPARE(good1->getQuantity(),quantity);
//        QCOMPARE(good1->getCurrencyType(),currencyid);
//        delete contractor2;
//        /*The other contstructor*/
//     //   contractor2 = new Contractor(id, name, address);
//        QCOMPARE(contractor1->getId(), id);
//        QCOMPARE(contractor1->getAddress(), address);
//        QCOMPARE(contractor1->getName(), name);
//        delete contractor2;
//        simpleTest = simpleTest.nextSiblingElement("Test");
//    }
//}

void TestGood::GetSetTest()
{
    testCase = root.firstChildElement("getSetTest");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        /*Get parameters from xml*/
        parametr = simpleTest.firstChildElement("param");
        id = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        name = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        price = parametr.text().toDouble();
        parametr = parametr.nextSiblingElement("param");
        remain = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        type = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        quantity= parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        currencyid = parametr.text().toInt();
        /*fulling object with data*/
        good1->setId(id);
        good1->setName(name);
        good1->setPrice(price);
        good1->setRemains(remain);
        good1->setType(type);
        good1->setQuantity(quantity);
        good1->setCurrencyType(currencyid);
        /*Checking*/
        QCOMPARE(good1->getId(),id);
        QCOMPARE(good1->getName(),name);
        QCOMPARE(good1->getPrice(),price);
        QCOMPARE(good1->getRemains(),remain);
        QCOMPARE(good1->getType(),type);
        QCOMPARE(good1->getQuantity(),quantity);
        QCOMPARE(good1->getCurrencyType(),currencyid);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}

void TestGood::mdb_good()
{
    testCase = root.firstChildElement("mdb_good");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        int unusedId=db->getUnusedId(good1->tableName());
        /*Get params from xml*/
        parametr = simpleTest.firstChildElement("param");
        id = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        name = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        price = parametr.text().toDouble();
        parametr = parametr.nextSiblingElement("param");
        remain = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        type = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        quantity= parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        currencyid = parametr.text().toInt();
        /*Creating the object*/
        good1->setId(id);
        good1->setName(name);
        good1->setPrice(price);
        good1->setRemains(remain);
        good1->setType(type);
        good1->setQuantity(quantity);
        good1->setCurrencyType(currencyid);
        /*Writing to database*/
        good1->set(db);
        good2 = new Good(db, unusedId);
        /*Checking*/
        QCOMPARE(good2->getId(),unusedId);
        QCOMPARE(good2->getName(),name);
        QCOMPARE(good2->getPrice(),price);
        QCOMPARE(good2->getRemains(),remain);
        QCOMPARE(good2->getType(),type);
        QCOMPARE(good2->getQuantity(),quantity);
        QCOMPARE(good2->getCurrencyType(),currencyid);
        delete good2;
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}
