#include "TestContractor.h"
#include "../../src/model/contractor.h"
#include <QtTest/QtTest>
#define NAME_OF_FILE "../TestContractor.xml"
#define NAME_OF_CLASS "TestContractor"

void TestContractor::initTestCase()
{
    /*Opening the file*/
    QString fileName = QString(NAME_OF_FILE);
    QFile file(fileName);
    if(!file.open(QFile::ReadOnly | QFile::Text)) qDebug("Error in opening the file");
    /*retranslating it to Dom structure*/
    QString errorStr;
    int errorLine;
    int errorColumn;
    if(!domDocument.setContent(&file, true, &errorStr, &errorLine, &errorColumn))
    {
        qDebug(errorStr.toAscii());
        qDebug(QString("%1").arg(errorLine).toAscii());
        qDebug(QString("%1").arg(errorColumn).toAscii());
    }

    /*Moving to the root*/
    root = domDocument.documentElement();
    if (root.tagName() != NAME_OF_CLASS) qDebug(root.tagName().toAscii());

    /*Making testing objects*/
    db = new Mdb();
    contractor1 = new Contractor();
    QVERIFY( contractor1 != 0 );
}

void TestContractor::cleanupTestCase()
{
    delete contractor1;
    contractor1 = 0;
    QVERIFY( contractor1 == 0);
}

void TestContractor::TestInitialization()
{
    /*Moving to TestCase TestInitialization*/
    testCase = root.firstChildElement("TestInitialization");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        /*getting parameters from xml file*/
        parametr = simpleTest.firstChildElement("param");
        id = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        name = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        address = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        phone = parametr.text();
        /*Creating the object*/
        contractor2 = new Contractor(id,name, address,phone);
        /*Verifying*/
        QCOMPARE(contractor2->getId(), id);
        QCOMPARE(contractor2->getAddress(), address);
        QCOMPARE(contractor2->getName(), name);
        QCOMPARE(contractor2->getPhone(), phone);
        delete contractor2;
        /*The other contstructor*/
        contractor2 = new Contractor(id, name, address);
        QCOMPARE(contractor2->getId(), id);
        QCOMPARE(contractor2->getAddress(), address);
        QCOMPARE(contractor2->getName(), name);
        delete contractor2;
        simpleTest = simpleTest.nextSiblingElement("Test");
    }

}

void TestContractor::getSetTest()
{
    testCase = root.firstChildElement("getSetTest");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        /*Get parameters from xml*/
        parametr = simpleTest.firstChildElement("param");
        id = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        name = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        address = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        phone = parametr.text();
        /*fulling object with data*/
        contractor1->setId(id);
        contractor1->setAddress(address);
        contractor1->setName(name);
        contractor1->setPhone(phone);
        /*Checking*/
        QCOMPARE(contractor1->getId(), id);
        QCOMPARE(contractor1->getAddress(), address);
        QCOMPARE(contractor1->getName(), name);
        QCOMPARE(contractor1->getPhone(), phone);
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}

void TestContractor::tableNameTest()
{
    QCOMPARE(QString("tblContractor"),contractor1->tableName());
}

void TestContractor::mdb_contractor()
{
    testCase = root.firstChildElement("mdb_contractor");
    simpleTest = testCase.firstChildElement("Test");
    while(!simpleTest.isNull()){
        int unusedId=db->getUnusedId(contractor1->tableName());
        /*Get params from xml*/
        parametr = simpleTest.firstChildElement("param");
        id = parametr.text().toInt();
        parametr = parametr.nextSiblingElement("param");
        name = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        address = parametr.text();
        parametr = parametr.nextSiblingElement("param");
        phone = parametr.text();
        /*Creating the object*/
        contractor1->setId(id);
        contractor1->setAddress(address);
        contractor1->setName(name);
        contractor1->setPhone(phone);
        /*Writing to database*/
        contractor1->set(db);
        contractor2 = new Contractor(db, unusedId);
        /*Checking*/
        QCOMPARE(contractor1->getId(), contractor2->getId());
        QCOMPARE(contractor1->getAddress(), contractor2->getAddress());
        QCOMPARE(contractor1->getName(), contractor2->getName());
        QCOMPARE(contractor1->getPhone(), contractor2->getPhone());
        delete contractor2;
        simpleTest = simpleTest.nextSiblingElement("Test");
    }
}
