#include <iostream>
#include <fstream>
#include <QtTest/QtTest>
#include <QApplication>

using namespace std;

ofstream logfile;




void DebugOutputHander(QtMsgType type, const char *msg)
{
    switch( type ) {
        case QtDebugMsg:
                logfile << QTime::currentTime().toString().toAscii().data() << "Debug: " << msg << "\n";
                logfile.flush();
                break;
        case QtCriticalMsg:
                logfile << QTime::currentTime().toString().toAscii().data() << "Critical: " << msg << "\n";
                logfile.flush();
                break;
        case QtWarningMsg:
                logfile << QTime::currentTime().toString().toAscii().data() << "Warning: " << msg << "\n";
                logfile.flush();
                break;
        case QtFatalMsg:
                logfile << QTime::currentTime().toString().toAscii().data() << "Fatal: " << msg << "\n";
                logfile.flush();
    }
}

