#include "splashprogressbar.h"

SplashProgressBar::SplashProgressBar(QPixmap pixmap)
    :QSplashScreen(pixmap)
{
    setStyleSheet(
            "QProgressBar {"
            "    border: 2px solid grey;"
            "    border-radius: 5px;"
            "}"

            "QProgressBar::chunk {"
            "   background-color: #05B8CC;"
            "    width: 20px;"
            "}"
            );

    qpbSplashProgress = new QProgressBar(this);
    qvblRootLayout = new QVBoxLayout();

    qpbSplashProgress->setMinimum(0);
    qpbSplashProgress->setMaximum(100);

    value = 0;

    qpbSplashProgress->setValue(value);

    qvblRootLayout->addWidget(qpbSplashProgress,1,Qt::AlignBottom);
    setLayout(qvblRootLayout);

    startTimer(50);
}

void SplashProgressBar::timerEvent(QTimerEvent *)
{
    value+=10;
    qpbSplashProgress->setValue(value);

    if(qpbSplashProgress->value()==100)
    {
        emit destroyed();
        close();
    }
}
