#ifndef SERVICESLISTDIALOG_H
#define SERVICESLISTDIALOG_H

#include <QDialog>
#include <QToolButton>
#include <QScrollArea>
#include <QAbstractItemModel>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QWidget>
#include <QGridLayout>
#include <QSpacerItem>

#include "servicelistitem.h"
#include "InformationObjects/serviceinfoobject.h"

#define ICO_WIDTH_HEIGHT 32
/**
  *Class displays a list of available services
  */
class ServicesListDialog : public QDialog
{
    Q_OBJECT;

    ///Scroll area of list imemt
    ///represents available services
    QScrollArea *qsaServicesListArea;
    QVBoxLayout *qvblRootLayout;
    QVBoxLayout *qvblScrollArea;
    QHBoxLayout *qhblButtonLayout;
    QVBoxLayout *qvblScrollLayout;
    QSpacerItem *qsiSpaicer;

    QFrame *qfScrollList;
    /**
      *Service Information object
      */
    ServiceInfoObject *sioServiceInfo;

    int _currentItemCount;
public:
    /**
      *constructor
      */
    ServicesListDialog(QWidget *parent = 0);

    void addMenuItem(QPushButton *menuItem);

public slots:
    /**
      *adds an item to the list of services
      *@param item
      */
    void addServiceListItem(ServiceListItem *item);
    /**
      *Sets the data model that contains a list of services
      *@param data model
      */
    void setServicesListModel(QAbstractItemModel *model);
    /**
      *method create a connection with maneger
      */
    void createConnectionManager();
    /**
      *slot reports about selected service
      */
    void serviceSelected(int id);


signals:
    /**
     * The signal to connect the object with the
     * information about the current service and
     * reports about switch between services
     * @param object for which you want to connect
     */
    void clientServiceInfoOblectRegistered(ServiceInfoObject *clientGoodInfo);



};

#endif // SERVICESLISTDIALOG_H
