/***************************************************************************

     pathwidget.cpp
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#include "pathwidget.h"
#include <QDebug>

PathWidget::PathWidget(QWidget *parent)
{

    setStyleSheet(
                "PathWidget{"
                    "background-color:black;"
                    "color:rgb(255, 165, 0);"
                    "font-size:16px;"
                    "font-weight:bold;"
                    "border-width:2px;"
                    "border-radius:0px;"
                "}"
                );

    qiSepratorIcon = QIcon(":/image/pathsepar.png");

    qlPathItemList = QList<PathWidgetItem *>();
    qhblPathItemLayout = new QHBoxLayout();
    pathItemsCount = 0;
    startPathModelIndex = 0;
    endPathModelIndex = 0;
    pathItemLenght = 0;

    setLayout(qhblPathItemLayout);
    setContentsMargins(0,0,0,0);
    qhblPathItemLayout->setContentsMargins(0,0,15,0);
    qhblPathItemLayout->setSpacing(3);

    qhblPathItemLayout->addStretch(8);
}

void PathWidget::setPathModel(QAbstractItemModel *pathModel)
{
    PathWidgetItem *pathItemSeparator;
    PathWidgetItem *newPathItem;
    int id;
    emit clearPathItems();

    pathItemLenght = 0;
    pathItemsCount = 0;
    clearPathItems();
    qaimPathModel = pathModel;
    qDebug()<<qaimPathModel->rowCount();
    startPathModelIndex = qaimPathModel->rowCount();
    for(int i=qaimPathModel->rowCount()-1;i>=0;i--)
    {
        if((qaimPathModel->index(i,1).data().convert(QVariant::String))&&
           (qaimPathModel->index(i,0).data().convert(QVariant::Int)))
        {
            id = qaimPathModel->index(i,0).data().toInt();
            newPathItem = new PathWidgetItem(id,
                                             qaimPathModel->index(i,1).data().toString(),
                                             this);
            if((pathItemLenght+newPathItem->width())<=(width()-18))
            {
                if(pathItemsCount!=0)
                {
                    pathItemSeparator = new PathWidgetItem(id,this);
                    pathItemSeparator->setIcon(qiSepratorIcon);
                    pathItemLenght+=pathItemSeparator->width();
                    qhblPathItemLayout->insertWidget(0,pathItemSeparator,0,Qt::AlignLeft);
                    connect(this,SIGNAL(clearPathItems()),pathItemSeparator,SLOT(deleteLater()));
                }
                qlPathItemList<<newPathItem;
                pathItemLenght+=newPathItem->width();
                qhblPathItemLayout->insertWidget(0,newPathItem,0,Qt::AlignLeft);
                pathItemsCount++;
                /**
                  *Signals report about click on some path item
                  */
                connect(newPathItem,SIGNAL(neesGoodsPath(int)),pioPathInfo,SIGNAL(needGoodsPath(int)));
                /**
                  *if avaliable new data model delete later widgets
                  */
                connect(this,SIGNAL(clearPathItems()),newPathItem,SLOT(deleteLater()));
            }
            else
            {
                delete newPathItem;
                endPathModelIndex = i+1;
                break;
            }
        }
        else
        {
            qDebug()<<tr("error in the data model, you can not convert data");
            break;
        }
    }
}

void PathWidget::setTreeModel(QAbstractItemModel *treeModel)
{

}

void PathWidget::addSeparator()
{

}

void PathWidget::addPathItem(PathWidgetItem *newPathItem)
{

}

void PathWidget::createConnectionManager()
{
    pioPathInfo = new PathInfoObject(this);

    connect(pioPathInfo,SIGNAL(readyGoodsPath(QAbstractItemModel*)),
            this,SLOT(setPathModel(QAbstractItemModel*)));
    /**
      *register the object in the manager
      */
    emit clientPathInfoOblectRegistered(pioPathInfo);
}


/*void PathWidget::clearPathItems()
{
    for(int i=0;i<qlPathItemList.count();i++)
    {
        delete qlPathItemList.takeAt(i);
    }
    pathItemLenght = 0;
    pathItemsCount = 0;
}*/
