#ifndef SERVICELOGO_H
#define SERVICELOGO_H

#include <QPushButton>
#include <QPainter>
#include <QPixmap>
#include <QToolButton>
#include <QWidget>
#include <QVBoxLayout>
#include <QAbstractListModel>
#include <QAction>
#include <QMenu>

#include "InformationObjects/serviceinfoobject.h"

#define SERVICE_ICON_WIDTH 64
#define SERVICE_ICON_HEIGHT 32

class ServiceLogo : public QWidget
{
    Q_OBJECT;

    QHBoxLayout *qhblRootLayout;

    QString qsLogoPath;
    QString qsOnlainStatus;
    QString qsDefaultPath;
    QString qsStatus;
    QPixmap qpLogoPixmap;
    QToolButton *qtbLogoButton;
    QToolButton *qtbOnlainStatus;
    QMenu *qmServicesMenu;

    ServiceInfoObject *sioServiceInfo;

public:
    ServiceLogo(QWidget *parent = 0);

public slots:
    /**
      *method create a connection with maneger
      */
    void createConnectionManager();

private slots:
    void setServiceLogo(const QString &text,bool online);
    void createServicesChooseMenu(QAbstractListModel *servicesList);
    void setServiceInfo(QAbstractItemModel *servicesInfo);
    /***FOR TEST**/
    void createServicesChooseMenu();
signals:
    /**
     * The signal to connect the object with the
     * information about the current service and
     * reports about switch between services
     * @param object for which you want to connect
     */
    void clientServiceInfoOblectRegistered(ServiceInfoObject *clientGoodInfo);

//protected:
//   void paintEvent(QPaintEvent *event);
};

#endif // SERVICELOGO_H
