#include "servicelogo.h"

ServiceLogo::ServiceLogo(QWidget *parent)
{

    qhblRootLayout = new QHBoxLayout();
    qsDefaultPath = QString(":/image/mgtrader.png");
    qsOnlainStatus = QString(":/image/onlain.png");
    qsLogoPath = qsDefaultPath;
    qpLogoPixmap = QPixmap(qsLogoPath);
    qsStatus = QString(tr("Offline"));
    qtbOnlainStatus = new QToolButton(this);
    qtbLogoButton = new QToolButton(this);

    qtbOnlainStatus->setIcon(QIcon(qsOnlainStatus));
    qtbOnlainStatus->setText(qsStatus);
    qtbOnlainStatus->setToolButtonStyle(Qt::ToolButtonIconOnly);
    qtbOnlainStatus->setContentsMargins(0,0,0,0);
    qtbOnlainStatus->setIconSize(QSize(SERVICE_ICON_WIDTH/2,SERVICE_ICON_HEIGHT/2));
    qtbOnlainStatus->setEnabled(false);
    qtbOnlainStatus->setStyleSheet(""
                                   "background-color:none;"
                                   "");

    qtbLogoButton->setIcon(QIcon(qpLogoPixmap));
    qtbLogoButton->setText(qsStatus);
    qtbLogoButton->setToolButtonStyle(Qt::ToolButtonIconOnly);
    qtbLogoButton->setContentsMargins(0,0,0,0);
    qtbLogoButton->setIconSize(QSize(SERVICE_ICON_WIDTH,SERVICE_ICON_HEIGHT));

    qhblRootLayout->setContentsMargins(0,0,0,0);
    qhblRootLayout->setSpacing(0);
    qhblRootLayout->addWidget(qtbLogoButton);
    qhblRootLayout->addWidget(qtbOnlainStatus);

    createServicesChooseMenu();

    setLayout(qhblRootLayout);
}

void ServiceLogo::setServiceLogo(const QString &text, bool online)
{
    qpLogoPixmap = QPixmap(text);
    qtbLogoButton->setIcon(QIcon(qpLogoPixmap));
    if(online)
    {
        qsStatus = tr("Online");
    }
    else
    {
        qsStatus = tr("OffLine");
    }
    qtbLogoButton->setEnabled(online);
    qtbLogoButton->setText(qsStatus);
}

void ServiceLogo::createServicesChooseMenu(QAbstractListModel *servicesList)
{
    qmServicesMenu = new QMenu(qtbLogoButton);

    QAction *qaLocal = new QAction(QIcon(":/image/localserv.png"),tr("&LocalDB"),qmServicesMenu);
    //connect(qaLocal,SIGNAL(triggered()),this,SLOT(ordersSelected()));

    /*Order action*/
    QAction *qaTest = new QAction(QIcon(":/image/mgtrader.png"),tr("&TestServ"),qmServicesMenu);
    //connect(qaTest,SIGNAL(triggered()),this,SLOT(ordersSelected()));

    qmServicesMenu->addAction(qaLocal);
    qmServicesMenu->addAction(qaTest);

    qtbLogoButton->setMenu(qmServicesMenu);

    //connect(qtbLogoButton,SIGNAL(clicked()),qtbLogoButton->menu(),SLOT(show()));
}

void ServiceLogo::createServicesChooseMenu()
{
    qmServicesMenu = new QMenu(qtbLogoButton);

    QAction *qaLocal = new QAction(QIcon(":/image/localserv.png"),tr("&LocalDB"),qmServicesMenu);
    //connect(qaLocal,SIGNAL(triggered()),this,SLOT(ordersSelected()));

    /*Order action*/
    QAction *qaTest = new QAction(QIcon(":/image/mgtrader.png"),tr("&TestServ"),qmServicesMenu);
    //connect(qaTest,SIGNAL(triggered()),this,SLOT(ordersSelected()));

    qmServicesMenu->addAction(qaLocal);
    qmServicesMenu->addAction(qaTest);

    qtbLogoButton->setMenu(qmServicesMenu);
}

void ServiceLogo::createConnectionManager()
{
    sioServiceInfo = new ServiceInfoObject(this);

    connect(sioServiceInfo,SIGNAL(availableServicesList(QAbstractListModel*)),
            this,SLOT(createServicesChooseMenu(QAbstractListModel*)));
    connect(sioServiceInfo,SIGNAL(serviceInfo(QAbstractItemModel*)),
            this,SLOT(setServiceInfo(QAbstractItemModel*)));
    /**
      *register an object to obtain information from the manager
      */
    emit clientServiceInfoOblectRegistered(sioServiceInfo);
}

void ServiceLogo::setServiceInfo(QAbstractItemModel *servicesInfo)
{

}
