/***************************************************************************

     pathwidget.h
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef PATHWIDGET_H
#define PATHWIDGET_H

#include <QWidget>
#include <QFrame>
#include <QHBoxLayout>
#include <QPushButton>
#include <QAbstractItemModel>
#include <QGroupBox>
#include <QComboBox>
#include <QList>

#include "pathwidgetitem.h"

#include "InformationObjects/pathinfoobject.h"

#include <QDebug>

class PathWidget : public QComboBox
{
    Q_OBJECT;

private:
    QHBoxLayout *qhblPathItemLayout;
    QGroupBox *qgbPathWidgetItemGroup;

    QAbstractItemModel *qaimPathModel;
    QAbstractItemModel *qaimTreeModel;

    /**
      *list of internal elements widget
      */
    QList<PathWidgetItem *> qlPathItemList;
    /**
      *Element awaiting information from the manager
      */
    PathInfoObject *pioPathInfo;

    int startPathModelIndex;
    int endPathModelIndex;
    int pathItemsCount;
    float pathItemLenght;

public:
    PathWidget(QWidget *parent = 0);
    /**
      *Adds a new element in the widget path
      *@param new item of path widget
      */
    void addPathItem(PathWidgetItem *newPathItem);

private:
    /**
      *The method adds a separator between
      *parts of the goods path
      */
    void addSeparator();

signals:
    /**
     * The signal to connect the object with the
     * information the specific opath of goods
     * @param object for which you want to connect
     */
    void clientPathInfoOblectRegistered(PathInfoObject *clientGoodInfo);

public slots:
    /**
      *Slots fill widget path of the goods
      */
    void setPathModel(QAbstractItemModel *pathModel);
    void setTreeModel(QAbstractItemModel *treeModel);
    /**
      *slots registered info objects after create outer connect
      */
    void createConnectionManager();
    void pathWidgetClear();
};

#endif // PATHWIDGET_H
