/***************************************************************************

     imainwidow.h
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef IMAINWINDOW_H
#define IMAINWINDOW_H

#include <QMainWindow>
#include <QAbstractItemModel>
#include <QWidget>

#include "InformationObjects/goodinfoobject.h"
#include "InformationObjects/goodsviewinfoobject.h"
#include "InformationObjects/pathinfoobject.h"
#include "InformationObjects/serviceinfoobject.h"
#include "InformationObjects/ordersinfoobject.h"

class IMainWindow : public QMainWindow
{
    Q_OBJECT;

public:
    IMainWindow(QWidget *parent = 0):QMainWindow(parent){};

signals:    
    /**
     * The signal to connect the object with the
     * information the specific product selected
     * @param object for which you want to connect
     */
    void clientGoodInfoOblectRegistered(GoodInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about list of goods and inner directory
     * @param object for which you want to connect
     */
    void clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about the current service and
     * reports about switch between services
     * @param object for which you want to connect
     */
    void clientServiceInfoOblectRegistered(ServiceInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information the specific opath of goods
     * @param object for which you want to connect
     */
    void clientPathInfoOblectRegistered(PathInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information the specific order or orders
     * @param object for which you want to connect
     */
    void clientOrdersInfoOblectRegistered(OrdersInfoObject *ordersInfo);

};

#endif // IMAINWINDOW_H
