/***************************************************************************

     guiplugin.h
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef GUIPLUGIN_H
#define GUIPLUGIN_H

#include <QObject>
#include <QtCore>
#include <QPixmap>
#include <QSplashScreen>

#include "graphicsinterface.h"
#include "imainwindow.h"
#include "splashprogressbar.h"
#include "mainwindow.h"

class GuiPlugin : public QObject,public GraphicsInterface
{
    Q_OBJECT;
    Q_INTERFACES( GraphicsInterface );

public:

    IMainWindow* getMainWindow(){return (static_cast<IMainWindow *>(new MainWindow()));}
    QSplashScreen* getSplashScreen()
    {
        Q_INIT_RESOURCE(res);
        return (qobject_cast<QSplashScreen *>(new SplashProgressBar(QPixmap(":/image/Splash.png"))));
    }

};

#endif // GUIPLUGIN_H
