/***************************************************************************

     goodswidget.h
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef PRODUCTWIDGET_H
#define PRODUCTWIDGET_H

#include <QWidget>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QAbstractItemModel>
#include <QAbstractListModel>
#include <QGroupBox>
#include <QFrame>
#include <QDebug>

#include "tableproduct.h"
#include "pathwidget.h"
#include "filteredit.h"
#include "treesearchdialog.h"
#include "servicelogo.h"

#include "InformationObjects/goodinfoobject.h"
#include "InformationObjects/goodsviewinfoobject.h"
#include "InformationObjects/pathinfoobject.h"
#include "InformationObjects/serviceinfoobject.h"

class GoodsWidget : public QFrame
{
    Q_OBJECT;

public:
    GoodsWidget(QWidget *parent = 0);

private:

    QHBoxLayout *qhblSearchHLayout;
    QHBoxLayout *qhblGroupHLayout;
    QGridLayout *qglGoodsGridLayout;
    QHBoxLayout *qhblPathLayout;

    QGroupBox *qgbSearchGroup;

    TableProduct *tpTableProduct;
    PathWidget *pwPathWidget;
    FilterEdit *feFilterEdit;
    TreeSearchDialog *tsdTreeSearch;
    ServiceLogo *slServiceLogo;

    GoodsViewInfoObject *gvioGoodsViewInfo;
    PathInfoObject *pioPathInfo;

public slots:
    /**
      *Event Update Network
      */
    void setNetworkUpdate();
    /**
      *slots registered info objects after create outer connect
      */
    void createConnectionManager();

signals:
    /**
     * The signal to connect the object with the
     * information the specific product selected
     * @param object for which you want to connect
     */
    void clientGoodInfoOblectRegistered(GoodInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about list of goods and inner directory
     * @param object for which you want to connect
     */
    void clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about the current service and
     * reports about switch between services
     * @param object for which you want to connect
     */
    void clientServiceInfoOblectRegistered(ServiceInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information the specific opath of goods
     * @param object for which you want to connect
     */
    void clientPathInfoOblectRegistered(PathInfoObject *clientGoodInfo);
    /**
      *
      */
    void connectCreateted();
};

#endif // PRODUCTWIDGET_H
