#include "contractorselectwidget.h"

ContractorSelectWidget::ContractorSelectWidget(QWidget *parent)
    :QDialog(parent)
{

    #if defined(Q_OS_LINUX)
    setAttribute(Qt::WA_Maemo5StackedWindow);
    #endif

    setMinimumHeight(500);

    setStyleSheet(
            "QTableView{"
            "background-color:black;"
            "color:rgb(255, 165, 0);"
            "border-radius:10px;"
            "font-size:18px;"
            "font-weight:bold;"
            "margin:0px;"
            "selection-background-color:"
            "qlineargradient(x1: 0, y1: 0, x2: 0, y2:1,"
            "stop: 0 rgb(255,140,0), stop: 1 rgb(255,165,0));"
            "}"
            "QHeaderView{"
            "color:white;"
            "font-weight:bold;"
            "font-size:14px;"
            "background-color:rgb(72,72,72);"
            "}"
            "QToolButton:hover{"
            " border-radius:6px;"
            " background-color:rgb(255,165,0);"
            "}"
            );

    qhblRootLayout = new QHBoxLayout();
    qvblContent = new QVBoxLayout();
    qvblRight = new QVBoxLayout();



    qtvContractorsTable = new QTableView(this);
    feFilter = new FilterEdit(this);
    qtbOk = new QToolButton(this);
    qtbBack = new QToolButton(this);
    qtbNext =  new QToolButton(this);
    qtbCansel = new QToolButton(this);

    qtbOk->setText(tr("Ok"));
    qtbBack->setText(tr("Back"));
    qtbNext->setText(tr("Next"));
    qtbCansel->setText(tr("Cansel"));

    QSize size = QSize(32,32);
    qtbOk->setIcon(QIcon(":/image/checkmark.ico"));
    qtbBack->setIcon(QIcon(":/image/back.png"));
    qtbNext->setIcon(QIcon(":/image/next.png"));
    qtbCansel->setIcon(QIcon(":/image/delete.ico"));

    qtbBack->setIconSize(size);
    qtbNext->setIconSize(size);
    qtbOk->setIconSize(size);
    qtbCansel->setIconSize(size);

    qvblRight->addWidget(qtbBack);
    qvblRight->addWidget(qtbNext);
    qvblRight->addWidget(qtbOk);
    qvblRight->addWidget(qtbCansel);

    qtvContractorsTable->setSelectionBehavior(QAbstractItemView::SelectRows);
    qtvContractorsTable->setSelectionMode(QAbstractItemView::SingleSelection);
    qtvContractorsTable->setProperty("FingerScrollable",true);

    qvblContent->addWidget(qtvContractorsTable);
    qvblContent->addWidget(feFilter);
    qvblContent->setSpacing(5);

    qhblRootLayout->addItem(qvblContent);
    qhblRootLayout->addItem(qvblRight);

    setLayout(qhblRootLayout);

    feFilter->setStyleSheet(
            "background-color:black;"
            "color:white;"
            );

    connect(qtbCansel,SIGNAL(clicked()),this,SLOT(close()));
    connect(qtbOk,SIGNAL(clicked()),this,SLOT(clickOk()));
    connect(qtvContractorsTable,SIGNAL(doubleClicked(QModelIndex)),this,SLOT(openInfo(QModelIndex)));
}

void ContractorSelectWidget::setContractorModel(QAbstractItemModel *model)
{
    qtvContractorsTable->setModel(model);
}

void ContractorSelectWidget::openInfo(const QModelIndex &modelOndex)
{

}

void ContractorSelectWidget::clickOk()
{

}
