#ifndef SERVICEINFOOBJECT_H
#define SERVICEINFOOBJECT_H

#include <QObject>
#include <QAbstractListModel>
#include <QAbstractItemModel>

class ServiceInfoObject : public QObject
{
    Q_OBJECT;
public:
    ServiceInfoObject(QObject *parent = 0);


public slots:
    void sendServiceSelectedSignal(int id);

signals:
    /**
     * Signal reports that the new service has been selected
     * @param ID of the selected service
     */
    void serviceSelected(int id);
    /**
      * Signal reports list of available services
      * @param model represents list available Services
      */
    void availableServicesList(QAbstractItemModel *servicesList);
    /**
      * Signal reports to maneger, what status changed
      * @param boolvalue: true is onlain status and false offlain
      */
    void serviceStatusChanged(bool servicesStatus);
    /**
      * Signal,include information describing the service
      * @param model that includes various information about the service
      */
    void serviceInfo(QAbstractItemModel *servicesInfo);
};

#endif // SERVICEINFOOBJECT_H
