#ifndef ORDERSINFOOBJECT_H
#define ORDERSINFOOBJECT_H

#include <QObject>
#include <QAbstractItemModel>

class OrdersInfoObject : public QObject
{
    Q_OBJECT;

public:
    OrdersInfoObject();

signals:
    /**
      *
      */
    void orderSelected(int id);
    /**
      *
      */
    void orderFiltrChanged(const QString &text);
    /**
      *
      */
    void readyOrdersList(QAbstractItemModel *ordersList);
    /**
      *
      */
    void newOrderCreated(QAbstractItemModel *newOrder);
    /**
      *
      */
    void readySalePoints(QAbstractItemModel *salePoints);
    /**
      *
      */
    void needOrderList(const QString &text);
    /**
      *
      */
    void needSalePoint(const QString &text);

public slots:
    void sendOrderSelectedSinal(int id);
    void sendFilterChangedSignal(const QString &text);
};

#endif // ORDERSINFOOBJECT_H
