#ifndef GOODINFOOBJECT_H
#define GOODINFOOBJECT_H

#include <QObject>
#include <QAbstractItemModel>

/**
  *Class representing an interface for receiving
  *information about a particular product
  */
class GoodInfoObject : public QObject
{
    Q_OBJECT;

public:
    GoodInfoObject(QObject *parent = 0);

public slots:
    void sendGoodInfoRequest(int id);

signals:
    /**
     * The name of the selected goods
     * @param model of data
     */
    void readyGoodsNameInfo(const QString &name);
    /**
     * The type of the selected goods
     * @param model of data
     */
    void readyGoodsTypeInfo(const QString &type);
    /**
     * The currency of the selected goods
     * @param model of data
     */
    void readyGoodsCurrencyInfo(const QString &currency);
    /**
     * The price of the selected goods
     * @param model of data
     */
    void readyGoodsPriceInfo(const QString &price);
    /**
     * The quantity of the selected goods
     * @param model of data
     */
    void readyGoodsQuantityInfo(const QString &quantity);
    /**
     * The remains of the selected goods
     * @param model of data
     */
    void readyGoodsRemainsInfo(const QString &remains);
    /**
     * The logo of the selected goods
     * @param model of data
     */
    void readyServiceLogo(const QString &logo);
    /**
     * The signal of request information about selected good
     * @param model of data
     */
    void needsGoodsInfo(int id);
};

#endif // GOODINFOOBJECT_H
