/***************************************************************************

     tableproduct.h
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef TABLEPRODUCT_H
#define TABLEPRODUCT_H

#include <QTableView>
#include <QHeaderView>
#include <QMouseEvent>
#include <QAbstractItemModel>
#include <QStandardItemModel>
#include <QStandardItem>
#include <QList>

#include "goodsinfodialog.h"
#include "InformationObjects/goodinfoobject.h"
#include "InformationObjects/goodsviewinfoobject.h"
#include "InformationObjects/pathinfoobject.h"

#define PRODUCT_ICON 0
#define PRODUCT_NAME 1
#define PRODUCT_TYPE 2
#define PRODUCT_COST 3


/**
  *Class for represent table of products
  *from a local DB*/
class TableProduct : public QTableView
{
    Q_OBJECT;
    GoodInfoObject *gioGoodInfo;
    PathInfoObject *pioPathInfo;
    QList<int> qlTypesList;

    int typeCount;
    int goodCount;

private:
    /**
      *methos add model in Table Model
      */
    void insertModel(QStandardItemModel *tableModel,
                     QAbstractItemModel *addedModel,
                     int startIndex = 0
                     );


public:
    TableProduct(QWidget *parent = 0);

private slots:
    /**
      * opens a dialog box containing
      * information about a specific product
      */
    void openGoodInfo(QModelIndex modelindex);
    /**
      *Sets the header data model tables
      */
    void setHorizontalHeader(QStandardItemModel *tableModel,QAbstractItemModel *headerSource);
    /**
      *Sets the header data model tables
      */
    void setVerticalHeader(QStandardItemModel *tableModel);

public slots:
    /**
     * @brief Fills the table with data
     * Fills the table with data
     * @param goodsTable - model, where the class is filled
     */
    void setGoodsTableModel(QAbstractItemModel *goodsTable);
    /**
     * @brief Fills the table with data
     * Fills the table with data
     * @param data model of goods and directory
     */
    void setGoodsTableModel(QAbstractItemModel *typeModel,
                            QAbstractItemModel *goodsModel);
    /**
      *slots registered info objects after create outer connect
      */
    void createConnectionManager();

signals:
    /**
     * The signal to connect the object with the
     * information the specific product selected
     * @param object for which you want to connect
     */
    void clientGoodInfoOblectRegistered(GoodInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about list of goods and inner directory
     * @param object for which you want to connect
     */
    void clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information the specific opath of goods
     * @param object for which you want to connect
     */
    void clientPathInfoOblectRegistered(PathInfoObject *clientGoodInfo);

};

#endif // TABLEPRODUCT_H
