/***************************************************************************

     tableproduct.cpp
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#include "tableproduct.h"

#include <QDebug>

TableProduct::TableProduct(QWidget *parent)
    :QTableView(parent)
{
    setSelectionBehavior(QAbstractItemView::SelectRows);
    setSelectionMode(QAbstractItemView::SingleSelection);
    setStyleSheet(
            "TableProduct{"
            "background-color:black;"
            "color:rgb(255, 165, 0);"
            "border-radius:10px;"
            "font-size:18px;"
            "font-weight:bold;"
            "margin:0px;"
            "selection-background-color:"
            "qlineargradient(x1: 0, y1: 0, x2: 0, y2:1,"
            "stop: 0 rgb(255,140,0), stop: 1 rgb(255,165,0));"
            "}"
            "QHeaderView{"
            "color:white;"
            "font-weight:bold;"
            "font-size:14px;"
            "background-color:rgb(72,72,72);"
            "}"
            );
    setProperty("FingerScrollable",true);
    setContentsMargins(0,0,0,0);
    setSortingEnabled(true);
    connect(this,SIGNAL(doubleClicked(QModelIndex)),this,SLOT(openGoodInfo(QModelIndex)));

}

void TableProduct::setGoodsTableModel(QAbstractItemModel *goodsTable)
{
    this->setModel(goodsTable);
    //setModel(goodsTable);
    horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    verticalHeader()->setResizeMode(QHeaderView::Fixed);
    verticalHeader()->setVisible(false);

}

void TableProduct::openGoodInfo(QModelIndex modelindex)
{
    qDebug()<<modelindex.data();

    /***********************************************************************/
    qDebug()<<modelindex.row()<<"ROW NUMBER";
    if(model()->index(modelindex.row(),0).data().canConvert(QVariant::Int))
    {
        GoodsInfoDialog *dialogInfo = new GoodsInfoDialog(this);
        switch(qlTypesList[modelindex.row()])
        {
        case 2:
            qDebug()<<"WAS SELECT GOOD";
            /******************set connects for fill content good info dialog*******/
            connect(gioGoodInfo,SIGNAL(readyGoodsNameInfo(QString)),
                    dialogInfo,SLOT(setName(QString)));
            connect(gioGoodInfo,SIGNAL(readyGoodsTypeInfo(QString)),
                    dialogInfo,SLOT(setType(QString)));
            connect(gioGoodInfo,SIGNAL(readyGoodsPriceInfo(QString)),
                    dialogInfo,SLOT(setPrice(QString)));
            connect(gioGoodInfo,SIGNAL(readyGoodsCurrencyInfo(QString)),
                    dialogInfo,SLOT(setCurrency(QString)));
            connect(gioGoodInfo,SIGNAL(readyGoodsQuantityInfo(QString)),
                    dialogInfo,SLOT(setQuantity(QString)));
            connect(gioGoodInfo,SIGNAL(readyGoodsRemainsInfo(QString)),
                    dialogInfo,SLOT(setRemains(QString)));
            connect(gioGoodInfo,SIGNAL(readyServiceLogo(QString)),
                    dialogInfo,SLOT(setServiseLogo(QString)));
            gioGoodInfo->sendGoodInfoRequest(model()->index(modelindex.row(),0).data().toInt());
            dialogInfo->show();
            break;
        case 1:
            pioPathInfo->sendPathItemSelected(model()->index(modelindex.row(),0).data().toInt());
            break;
        case 0:
            qDebug()<<"PARENT NODE"<<model()->index(modelindex.row(),0).data().toInt();
            pioPathInfo->sendPathItemSelected(model()->index(modelindex.row(),0).data().toInt());
            break;
        }
    }
    else
    {
        qDebug()<<"Error uncorrect Id type";
        return;
    }

}

void TableProduct::createConnectionManager()
{
    gioGoodInfo = new GoodInfoObject(this);
    pioPathInfo = new PathInfoObject(this);

    emit clientGoodInfoOblectRegistered(gioGoodInfo);
    emit clientPathInfoOblectRegistered(pioPathInfo);
}

void TableProduct::setGoodsTableModel(QAbstractItemModel *typesModel,
                                      QAbstractItemModel *goodsModel)
{
    qlTypesList.clear();
    typeCount = typesModel->rowCount();
    goodCount = goodsModel->rowCount();

    int columnCount;
    if(goodsModel->columnCount()>typesModel->columnCount())
    {
        columnCount = goodsModel->columnCount();
    }
    else
    {
        columnCount = typesModel->columnCount();
    }
    QStandardItemModel *tableModel = new QStandardItemModel(goodCount+typeCount-1,
                                                            columnCount-1,
                                                            this);
    insertModel(tableModel,typesModel);
    insertModel(tableModel,goodsModel,typesModel->rowCount());

    setHorizontalHeader(tableModel,goodsModel);
    setVerticalHeader(tableModel);

    hideColumn(0);
    hideColumn(1);

    setModel(tableModel);
    horizontalHeader()->setResizeMode(QHeaderView::ResizeToContents);
    verticalHeader()->setResizeMode(QHeaderView::Fixed);
    //verticalHeader()->setVisible(false);
}

void TableProduct::insertModel(QStandardItemModel *tableModel,
                               QAbstractItemModel *addedModel,
                               int startIndex)
{
    QStandardItem * itemModel;
    for(int i = 0;i<addedModel->rowCount();i++)
    {
        for(int j = 0;j<addedModel->columnCount();j++)
        {
            if(j!=1)
            {
                itemModel = new QStandardItem(addedModel->index(i,j).data().toString());
                itemModel->setEditable(false);
                tableModel->setItem(i+startIndex,
                                    j,
                                    itemModel);
            }
        }
        qlTypesList<<addedModel->index(i,1).data().toInt();
    }
}

void TableProduct::setHorizontalHeader(QStandardItemModel *tableModel,
                                       QAbstractItemModel *headerSource)
{
    for(int i=0;i<headerSource->columnCount();i++)
    {
        tableModel->setHorizontalHeaderItem(i,
                                            new QStandardItem(headerSource->headerData(i,Qt::Horizontal).toString()));
    }
}

void TableProduct::setVerticalHeader(QStandardItemModel *tableModel)
{
    for(int i=0;i<tableModel->rowCount();i++)
    {
        switch(qlTypesList[i])
        {
        case 0:
            tableModel->setVerticalHeaderItem(i,new QStandardItem());
            tableModel->verticalHeaderItem(i)->setIcon(QIcon(":/image/dir.png"));
            break;
        case 1:
            tableModel->setVerticalHeaderItem(i,new QStandardItem());
            tableModel->verticalHeaderItem(i)->setIcon(QIcon(":/image/dir.png"));
            break;
        case 2:
            tableModel->setVerticalHeaderItem(i,new QStandardItem());
            tableModel->verticalHeaderItem(i)->setIcon(QIcon(":/image/goods.png"));
            break;
        case 5:
            break;
        }
    }
}
