#include "serviceslistdialog.h"

ServicesListDialog::ServicesListDialog(QWidget *parent)
    :QDialog(parent)
{
    qsaServicesListArea = new QScrollArea;
    qfScrollList = new QFrame(this);
    qvblScrollLayout = new QVBoxLayout();
    qvblScrollArea = new QVBoxLayout();
    //qglMenuLayout = new QGridLayout(qsaServicesListArea);

    qvblScrollLayout->setContentsMargins(0,5,0,0);
    qsaServicesListArea->setWidget(qfScrollList);
    qvblScrollLayout->addWidget(qfScrollList);

    qsaServicesListArea->setProperty("FingerScrollable",true);

    qfScrollList->setLayout(qvblScrollArea);
    setLayout(qvblScrollLayout);

    setMinimumHeight(300);

    setStyleSheet(
                  "font-size:23px;"
                  "border-radius:10px;"
                  "background-color:black;"
                  "font-weight:bold;"
                  "border-style:solid;"
                  "border-width:3px;"
                  "border-color:rgb(88,88,88);"
                  );

    ServiceListItem *localDB = new ServiceListItem(0,
                                                   QIcon(tr(":/image/localserv.png")),
                                                   tr("Local DB"),
                                                   false,
                                                   qfScrollList);
    ServiceListItem *testService = new ServiceListItem(1,
                                                   QIcon(tr(":/image/mgtrader.png")),
                                                   tr("Test Service"),
                                                   false,
                                                   qfScrollList);
    addServiceListItem(localDB);
    addServiceListItem(testService);
    qvblScrollArea->addStretch(6);
}

void ServicesListDialog::addServiceListItem(ServiceListItem *item)
{
    QHBoxLayout *itemLayout = new QHBoxLayout();
    item->setStyleSheet(
                        ":hover{"
                        "  background-color: qlineargradient(x1:0, y1:0, x2:1, y2:1,stop:0 black, stop: 0.7 gray, stop:1 white);"
                        "  color:rgb(255, 165, 0);"
                        "}"
                        ":active{"
                        " color:rgb(255, 165, 0);"
                        " border-radius:8px;"
                        " background-color: rgb(72,72,72); "
                        " margin-bottom:8px;"
                        " margin-left:5px;"
                        " margin-right:5px;"
                        "}"
                        ":pressed{"
                        " color:white;"
                        " border-radius:8px;"
                        " background:qlineargradient(x1:0, y1:0, x2:0, y2:1,stop:0 rgb(210, 105, 30),stop:0.5 rgb(255,140,0),stop:1 rgb(255,165,0));"
                        "}"
                        );
    itemLayout->addWidget(item);
    qvblScrollArea->addItem(itemLayout);
    qvblScrollArea->setAlignment(itemLayout,Qt::AlignTop);
    /**
      *We connect the signal selection element, with the signal service change
      */
    connect(item,SIGNAL(itemClick(int)),this,SIGNAL(serviceSelected(int)));
}

void ServicesListDialog::setServicesListModel(QAbstractItemModel *model)
{
    ////TO DO PARSE MODEL AND CREATE ITEMS;
}
