#ifndef SERVICELISTITEM_H
#define SERVICELISTITEM_H

#include <QPushButton>
#include <QIcon>
/**
  *The class is inherited from QPushButton, it added parameter identifier
  */
class ServiceListItem : public QPushButton
{
    Q_OBJECT;

    QString qsName;
    QString qsIconPath;
    int _id;
    bool _currentStatus;

public:
    /**
      *Constructor
      */
    ServiceListItem(int id,
                    const QIcon &serviceIcon,
                    const QString &serviceName,
                    bool status,
                    QWidget *parent = 0);

signals:
    void itemClick(int id);

private slots:
    void clickReact();

};

#endif // SERVICELISTITEM_H
