/***************************************************************************

     orderwidget.h
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef ORDERWIDGET_H
#define ORDERWIDGET_H

#include <QHBoxLayout>
#include <QDebug>

#include "ordermenuwidget.h"
#include "goodswidget.h"
#include "ordermenucontrol.h"
#include "neworder.h"
#include "orders/orderinfowidget.h"

#include "InformationObjects/goodinfoobject.h"
#include "InformationObjects/goodsviewinfoobject.h"
#include "InformationObjects/pathinfoobject.h"
#include "InformationObjects/serviceinfoobject.h"

class OrderWidget : public QFrame
{
    Q_OBJECT;

private:
    QHBoxLayout *qhblOrderLayout;
    OrderMenuWidget *omwOrderMenu;
    GoodsWidget *gwGoods;
    OrderMenuControl *omcOrderMenu;
    OrderInfoWidget *oiwOrders;
    NewOrder *noNewOrder;
    QObject *currentWidget;

    int id;
    int currentState;
    int previousState;

signals:
    /**
     * The signal to connect the object with the
     * information the specific product selected
     * @param object for which you want to connect
     */
    void clientGoodInfoOblectRegistered(GoodInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about list of goods and inner directory
     * @param object for which you want to connect
     */
    void clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about the current service and
     * reports about switch between services
     * @param object for which you want to connect
     */
    void clientServiceInfoOblectRegistered(ServiceInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information the specific opath of goods
     * @param object for which you want to connect
     */
    void clientPathInfoOblectRegistered(PathInfoObject *clientGoodInfo);




    void clientOrdersInfoOblectRegistered(OrdersInfoObject *ordersInfo);
    /**
      *
      */
    void connectCreated();

public:
    OrderWidget(int type_id, QWidget *parent = 0);

private slots:
    /**
      *slot sets the current widget is displayed
      *@param state of widget
      */
    void setState(int newState);
};

#endif // ORDERWIDGET_H
