#ifndef ORDERMENUCONTROL_H
#define ORDERMENUCONTROL_H

#include <QObject>
#include <QDialog>
#include <QWidget>

#include "ordermenuwidget.h"
#include "serviceslistdialog.h"

#define MENU_STATE 1
#define NEW_ORDER_STATE 2
#define VIEW_GOODS_STATE 3
#define VIEW_ORDER_STATE 4
#define NOTHING 0
#define CANSEL_STATE -1

#define COMMON_ORDER_MENU 0
#define SERVICE_CHOOSE_DIALOG 1

class OrderMenuControl : public QObject
{
    Q_OBJECT;

    ///Dialog include list of avaliable services
    ServicesListDialog *sldServicesList;
    ///Dialog include main actions with orders
    OrderMenuWidget *omwOrderCommonDialog;
    QDialog *qdCurrentDialog;
    QWidget *qwParent;

    int currentState;
    int prevState;

public:
    OrderMenuControl(QWidget *parent = 0);

private slots:
    /**
      *Slost for every inner dialog
      */
    void showServiceListDialog();
    void showCommonOrdersDialog();
    /**
      *     ,    
      */
    void signalFromServiceDialog(int id);
    /**
      *
      */
    void ordersViewSelected();
    /**
      *
      */
    void newOrderSelected();

signals:
    /**
      *  
      */
    void serviseChoose(int id);
    void stateChanged(int newState);
};

#endif // ORDERMENUCONTROL_H
