#include "neworder.h"

NewOrder::NewOrder(QWidget *parent)
    :QFrame(parent)
{

    qhblButtonLayout = new QVBoxLayout();
    qglNewOrderGrid = new QGridLayout();
    qleText1 = new QLineEdit(this);
    qleText2 = new QLineEdit(this);
    qleText3 = new QLineEdit(this);
    qleText4 = new QLineEdit(this);

    qpbView = new QPushButton(tr("Orders View"),this);

    qglNewOrderGrid->addWidget(qleText1,0,0);
    qglNewOrderGrid->addWidget(qleText2,0,1);
    qglNewOrderGrid->addWidget(qleText3,1,0);
    qglNewOrderGrid->addWidget(qleText4,1,1);
    qglNewOrderGrid->setSpacing(20);

    qhblButtonLayout->addItem(qglNewOrderGrid);
    qhblButtonLayout->addWidget(qpbView,0,Qt::AlignCenter);


    setStyleSheet(
            "NewOrder{"
            " background-color:black;"
            "}"
            );

    setLayout(qhblButtonLayout);

    connect(qpbView,SIGNAL(clicked()),this,SLOT(openOrdersView()));
}

void NewOrder::openOrdersView()
{
    OrdersListDialog *ordersDialog = new OrdersListDialog();

    ordersDialog->show();
}

void NewOrder::createConnectManager()
{
    oioOrdersInfo = new OrdersInfoObject();

    emit clientOrdersInfoOblectRegistered(oioOrdersInfo);
}
