/***************************************************************************

     mainwindow.h
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QToolBar>
#include <QAction>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QPushButton>
#include <QGroupBox>
#include <QGridLayout>
#include <QIcon>
#include <QFrame>
#include <QSpacerItem>

#include "imainwindow.h"
#include "navigationbutton.h"
#include "commoncontentwidget.h"
#include "logowidget.h"
#include "orderwidget.h"

/**
  *Icon Size
  */
#define ICON_WIDTH 64
#define ICON_HEIGHT 64

#define NAVIGATION_BUT_WIDTH 110
/**
  *MainWindow Size
  */
#define WND_WIDTH 800
#define WND_HEIGHT 480

#define NAVIGATION_COUNT 5
#define NAVIGATION_FONT_SIZE 14

#define CONTENT_STRETCH 9

#define NOTHING_CHECK -1

#define ORDER_TYPE 0
#define SALE_TYPE 1
#define PROFILE_TYPE 2
#define REPORT_TYPE 3
#define SETTING_TYPE 4
#define SPLASH_TYPE 5

class MainWindow : public IMainWindow
{
    Q_OBJECT;

private:
    /**
      *Form layouts
      */
    QVBoxLayout *qvblNavigation;
    QGridLayout *qglMainWindowGrid;
    QHBoxLayout *qhblContent;
    /**
      *Main menu of applicatuion
      */
    QAction *qaOrders;
    QAction *qaProfiles;
    QAction *qaReports;
    QAction *qaSales;
    QAction *qaConfiguration;
    /**
      *
      */
    NavigationButton *qpbOrders;
    NavigationButton *qpbProfiles;
    NavigationButton *qpbReports;
    NavigationButton *qpbSales;
    NavigationButton *qpbSettings;
    NavigationButton *qpbSpacer;

    QWidget *qwContentWidget;

    QWidget *ccwCurrentContentWidget;
    /**
     *Actions for left toolbar
     */
    QAction *qaRefresh;
    QAction *qaSearch;
    QAction *qaAdd;
    /**
      * central Widget
      */
    QFrame *qfCentralFrame;
    /**
      *current state, shows how the tab is currently running user
      */
    int currentState;
    /**
      *index of checked navigation button
      */
    NavigationButton *checkedNavigationButton;

    int checkedNavigationButtonId;
    /**
      *array of pointers to the main navigation buttons application
      */
    NavigationButton *NavigationList[NAVIGATION_COUNT];
    /**
      *The widget displays the startup logo
      */
    LogoWidget *lwLogo;
    /**
      *Widget contains orders
      */
    OrderWidget *owOrderWidget;

public:
    MainWindow();

private:
    void createToolBars();
    void createActions();
    //void createConnectToGoodsInfo(OrderWidget *handler);

signals:
    /**
     * The signal to connect the object with the
     * information the specific product selected
     * @param object for which you want to connect
     */
    void clientGoodInfoOblectRegistered(GoodInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about list of goods and inner directory
     * @param object for which you want to connect
     */
    void clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information about the current service and
     * reports about switch between services
     * @param object for which you want to connect
     */
    void clientServiceInfoOblectRegistered(ServiceInfoObject *clientGoodInfo);
    /**
     * The signal to connect the object with the
     * information the specific opath of goods
     * @param object for which you want to connect
     */
    void clientPathInfoOblectRegistered(PathInfoObject *clientGoodInfo);


    void clientOrdersInfoOblectRegistered(OrdersInfoObject *ordersInfo);
    //void clientGoodInfoOblectConnected(GoodInfoObject *clientGoodInfo);
    //void serviceChanged(int id);
    //void needGoodsTable(const QString &filtr = tr(""));
    //void needGoodsPath(int id);
    //void readyGoodsTable(QAbstractItemModel *model);
    //void readyGoodsPath(QAbstractItemModel *model);
    //void readyGoodsDirectory(QAbstractItemModel *model);//readyGoodsTree last name
    //void needsGoodsInfo(int);
    /*void readyGoodsNameInfo(QAbstractItemModel *model);
    void readyGoodsTypeInfo(QAbstractItemModel *model);
    void readyGoodsCurrencyInfo(QAbstractItemModel *model);
    void readyGoodsPriceInfo(QAbstractItemModel *model);
    void readyGoodsQuantityInfo(QAbstractItemModel *model);
    void readyGoodsRemainsInfo(QAbstractItemModel *model);
    void readyServiceLogo(QAbstractItemModel *model);*/

    void contentMenuCanBeReturned();

private slots:
    //void goodsInfoRequest(int id);
    /**
      * slot creates navigation buttons application
      */
    void createMainNavigationControl();
    /**
      * slot is called when switching
      * between the navigation buttons
      */
    void navigationButttonCheckedEvent(NavigationButton *navigationbutton);
    /**
      * sets the widget content identifier
      */
    void setContent(int stateId);

};

#endif // MAINWINDOW_H
