#include "pathwidgetitem.h"

PathWidgetItem::PathWidgetItem(int id,const QString &text,QWidget *parent)
    :QToolButton(parent)
{
    Id = id;
    qsText = text;
    setToolButtonStyle(Qt::ToolButtonTextBesideIcon);

    setText(qsText);

    setStyleSheet(
            "PathWidgetItem{"
                "background-color:rgb();"
                "border-bottom-right-radius:10px;"
                "border-top-right-radius:10px;"
                "border-style:none;"
                "margin:0px;"
                "font-weight:bold;"
                "font-size:12px;"
                "color:white;"
                "padding-right:0px;"
            "}"
            "PathWidgetItem:hover{"
                "background: qlineargradient(x1:0, y1:0, x2:0, y2:1,stop:0 black, stop: 0.5 gray, stop:1 white);"
                "border-width:0px;"
                "border-radius:10px;"
                "color:rgb(255, 165, 0);"
            "}"
            );
    connect(this,SIGNAL(clicked()),this,SLOT(clickResponse()));
}

void PathWidgetItem::clickResponse()
{
    emit neesGoodsPath(Id);
}

