#ifndef ORDERMENUCONTROL_H
#define ORDERMENUCONTROL_H

#include <QObject>
#include <QDialog>
#include <QWidget>

#include "ordermenuwidget.h"
#include "servicechoosewidget.h"
#include "InformationObjects/serviceinfoobject.h"

#define MENU_STATE 1
#define NEW_ORDER_STATE 2
#define VIEW_GOODS_STATE 3
#define VIEW_ORDER_STATE 4
#define NOTHING 0
#define CANSEL_STATE -1

#define COMMON_ORDER_MENU 0
#define SERVICE_CHOOSE_DIALOG 1

class OrderMenuControl : public QObject
{
    Q_OBJECT;

    ServiceChooseWidget *scwServiceDialog;
    OrderMenuWidget *omwOrderCommonDialog;
    QDialog *qdCurrentDialog;
    QWidget *qwParent;

    int currentState;
    int prevState;

    ServiceInfoObject *serviceInfo;

public:
    OrderMenuControl(QWidget *parent = 0);

public slots:
    /**
      *slots registered info objects after create outer connect
      */
    void createConnectionManager();

private slots:
    /**
      *   
      */
    void showServiceChooseDialog();
    void showCommonOrdersDialog();
    /**
      *     ,    
      */
    void signalFromServiceDialog(int id);

signals:
    /**
      *  
      */
    void serviseChoose(int id);

    void stateChanged(int newState);
    /**
     * The signal to connect the object with the
     * information about the current service and
     * reports about switch between services
     * @param object for which you want to connect
     */
    void clientServiceInfoOblectRegistered(ServiceInfoObject *clientGoodInfo);
};

#endif // ORDERMENUCONTROL_H
