/***************************************************************************

navigationbutton.h
-------------
Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

***************************************************************************/
/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,	  *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of	  *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	  *
*   GNU General Public License for more details.			  *
* 									  *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the Free Software	          *
*   Foundation, Inc., 51 Franklin Street,                                 *
*   Fifth Floor, Boston, MA  02110-1301, USA.                             *
*                                                                         *
***************************************************************************/
#ifndef NAVIGATIONBUTTON_H
#define NAVIGATIONBUTTON_H

#include <QPushButton>
#include <QIcon>

class NavigationButton : public QPushButton
{
    Q_OBJECT;

private:
    /**
      *
      */
    int Id;

    /**
      *
      */
    QString qsFloatText;
    bool floatTextVisible;

public:
    /**
      *Construcntors
      */
    NavigationButton(const QIcon &icon,const QString &text,QWidget *parent = 0);
    NavigationButton(const QString &text,QWidget *parent = 0);
    NavigationButton(QWidget *parent = 0);

    /**
      *
      */
    void setId(int id);
    int id();
    /**
      *
      */
    void setFloatText(const QString &text);
    void setFloatTextVisible(bool visible);
    QString floatText();

    /**
      *
      */
    void createConnects();

/*protected:
    void focusInEvent(QFocusEvent *);*/

private slots:
    void clickReact();

signals:
    void changeStyleSheet(const QString &text);
    void checkedChanged(NavigationButton *navigationButton);
    void floatTextVisibleChange(bool visible);
    void clickId(int id);
};

#endif // NAVIGATIONBUTTON_H
