/***************************************************************************

     mainwindow.cpp
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#include "mainwindow.h"

#include <QGroupBox>

MainWindow::MainWindow()
    :IMainWindow()
{
    /**
      *initializes resources GUI
      */
    Q_INIT_RESOURCE(res);

    setFixedSize(WND_WIDTH,WND_HEIGHT);

    setStyleSheet(
            "MainWindow{"
                "background-color:#1C1C1C;"
            "}"
            "MainWindow,QFrame{"
                "margin:0px;"
                "padding:0px;"
            "}"
            );
    setWindowTitle(tr("mobile-trade"));

    qfCentralFrame = new QFrame(this);

    qwContentWidget = new QWidget(qfCentralFrame);
    lwLogo = new LogoWidget(qwContentWidget);
    /**
      *An object containing references to the current content, to remove it, in case of change
      */
    ccwCurrentContentWidget = lwLogo;

    qhblContent = new QHBoxLayout();
    qvblNavigation = new QVBoxLayout();
    qglMainWindowGrid = new QGridLayout();

    createMainNavigationControl();

    qhblContent->addWidget(lwLogo);
    qwContentWidget->setLayout(qhblContent);
    qglMainWindowGrid->addWidget(qwContentWidget,0,1,0,11);
    qglMainWindowGrid->setHorizontalSpacing(0);

    qfCentralFrame->setLayout(qglMainWindowGrid);
    setCentralWidget(qfCentralFrame);

    qwContentWidget->setStyleSheet(
                                   "border-radius:15px;"
                                   "margin-left:0px;"
                                   "padding-left:0px;"
                                   );
    qwContentWidget->setContentsMargins(0,0,0,0);
    qhblContent->setContentsMargins(0,0,0,0);
    qvblNavigation->setContentsMargins(0,0,0,0);
}

void MainWindow::createMainNavigationControl()
{
    qvblNavigation->setSizeConstraint(QLayout::SetMinimumSize);

    qpbOrders = new NavigationButton(tr("Orders"),qfCentralFrame);
    qpbOrders->setIcon(QIcon(":/image/orders.png"));

    qpbSales = new NavigationButton(tr("Sales"),qfCentralFrame);
    qpbSales->setIcon(QIcon(":/image/sales.png"));

    qpbProfiles = new NavigationButton(tr("Profiles"),qfCentralFrame);
    qpbProfiles->setIcon(QIcon(":/image/profile.png"));

    qpbReports = new NavigationButton(tr("Reports"),qfCentralFrame);
    qpbReports->setIcon(QIcon(":/image/report.png"));

    qpbSettings = new NavigationButton(tr("Settings"),qfCentralFrame);
    qpbSettings->setIcon(QIcon(":/image/configuration.png"));

    NavigationList[0] = qpbOrders;
    NavigationList[1] = qpbSales;
    NavigationList[2] = qpbProfiles;
    NavigationList[3] = qpbReports;
    NavigationList[4] = qpbSettings;

    for(int i=0;i<NAVIGATION_COUNT;i++)
    {
        NavigationList[i]->setFont(QFont(tr("Arial"),NAVIGATION_FONT_SIZE));
        NavigationList[i]->setIconSize(QSize(ICON_WIDTH,ICON_HEIGHT));
        NavigationList[i]->setCheckable(true);
        NavigationList[i]->setId(i);
        qvblNavigation->addWidget(NavigationList[i],0,Qt::AlignLeft|Qt::AlignVCenter);
        connect(NavigationList[i],SIGNAL(checkedChanged(NavigationButton*)),
                this,SLOT(navigationButttonCheckedEvent(NavigationButton*)));
        connect(NavigationList[i],SIGNAL(clickId(int)),this,SLOT(setContent(int)));
    }
    checkedNavigationButtonId = NOTHING_CHECK;
    checkedNavigationButton = NavigationList[ORDER_TYPE];

    qglMainWindowGrid->addItem(qvblNavigation,0,0,Qt::AlignLeft);
}
/****************Don't use now*************************
void MainWindow::createToolBars()
{

    QToolBar *qtbLeftToolBar = new QToolBar(this);
    qtbLeftToolBar->addAction(qaOrders);
    qtbLeftToolBar->addAction(qaSales);
    qtbLeftToolBar->addAction(qaReports);
    qtbLeftToolBar->addAction(qaProfiles);
    qtbLeftToolBar->addAction(qaConfiguration);

    qtbLeftToolBar->setIconSize(QSize(ICON_WIDTH,ICON_HEIGHT));
    qtbLeftToolBar->setMovable(false);

    addToolBar(Qt::TopToolBarArea,qtbLeftToolBar);


    QToolBar *qtbRightToolBar = new QToolBar(this);
    qtbRightToolBar->addAction(qaAdd);
    qtbRightToolBar->addSeparator();
    qtbRightToolBar->addAction(qaSearch);
    qtbRightToolBar->addSeparator();
    qtbRightToolBar->addAction(qaRefresh);

    qtbRightToolBar->setMovable(false);

    addToolBar(Qt::BottomToolBarArea,qtbRightToolBar);
}*/
/*************************Don't use now********************************/
void MainWindow::createActions()
{
    /*Order action*/
    qaOrders = new QAction(QIcon(":/image/orders.png"),tr("&Orders"),this);
    connect(qaOrders,SIGNAL(triggered()),this,SLOT(ordersSelected()));
    /*Profiles action*/
    qaProfiles = new QAction(QIcon(":/image/profile.png"),tr("&Orders"),this);
    connect(qaProfiles,SIGNAL(triggered()),this,SLOT(profileSelected()));
    /*Sales action*/
    qaSales = new QAction(QIcon(":/image/sales.png"),tr("Orders"),this);
    connect(qaSales,SIGNAL(triggered()),this,SLOT(salesSelected()));
    /*Reports action*/
    qaReports = new QAction(QIcon(":/image/report.png"),tr("Orders"),this);
    connect(qaReports,SIGNAL(triggered()),this,SLOT(reportsSelected()));
    /**/
    qaConfiguration = new QAction(QIcon(":/image/configuration.png"),tr("Orders"),this);
    connect(qaConfiguration,SIGNAL(triggered()),this,SLOT(configurationSelected()));

    ///
    /**
     **Action for Right tool bar*/
    qaAdd = new QAction(QIcon(":/image/plus.ico"),tr("Add"),this);
    connect(qaAdd,SIGNAL(triggered()),this,SLOT(addSelected()));
    /**/
    qaSearch = new QAction(QIcon(":/image/search.png"),tr("Search"),this);
    connect(qaSearch,SIGNAL(triggered()),this,SLOT(searchSelected()));
    /**/
    qaRefresh = new QAction(QIcon(":/image/refresh.ico"),tr("Update"),this);
    connect(qaRefresh,SIGNAL(triggered()),this,SLOT(refreshSelected()));
}

void MainWindow::setContent(int ContentId)
{
    if(ContentId>=0&&ContentId<NAVIGATION_COUNT)
    {
        switch(ContentId)
        {

            case ORDER_TYPE:
                delete ccwCurrentContentWidget;
                owOrderWidget = new OrderWidget(ORDER_TYPE,qwContentWidget);
                qhblContent->addWidget(owOrderWidget);
                ccwCurrentContentWidget = owOrderWidget;

                connect(owOrderWidget,SIGNAL(clientGoodInfoOblectRegistered(GoodInfoObject*)),
                        this,SIGNAL(clientGoodInfoOblectRegistered(GoodInfoObject*)));
                connect(owOrderWidget,SIGNAL(clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject*)),
                        this,SIGNAL(clientGoodsViewInfoOblectRegistered(GoodsViewInfoObject*)));
                connect(owOrderWidget,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)),
                        this,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)));
                connect(owOrderWidget,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)),
                        this,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)));

                connect(this,SIGNAL(connectCreateted()),owOrderWidget,SLOT(createConnectionManager()));

                emit contentMenuCanBeReturned();

                emit connectCreateted();

                break;
            case SALE_TYPE:
                break;
            case REPORT_TYPE:
                break;
            case PROFILE_TYPE:
                break;
            case SETTING_TYPE:
                break;
            case SPLASH_TYPE:
                break;
        }
    }
}

void MainWindow::navigationButttonCheckedEvent(NavigationButton *navigationButton)
{
    if(navigationButton->id()!=checkedNavigationButtonId)
    {
        if(navigationButton->isChecked())
        {
            checkedNavigationButton->setChecked(false);
            checkedNavigationButton->setFloatTextVisible(false);
            checkedNavigationButton = navigationButton;
            checkedNavigationButton->setChecked(true);
            checkedNavigationButton->setFloatTextVisible(true);
            checkedNavigationButtonId = checkedNavigationButton->id();
        }
        else
        {
            checkedNavigationButton->setFloatTextVisible(true);
        }
    }
    else
    {
        navigationButton->setChecked(true);
    }
}
