/***************************************************************************

     goodswidget.cpp
     -------------
     Copyright (c) 2010 by Mihailov Sergei <smihailo@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#include "goodswidget.h"

GoodsWidget::GoodsWidget(QWidget *parent)
    :QFrame(parent)
{
    setContentsMargins(0,0,0,0);

    qglGoodsGridLayout = new QGridLayout();
    qhblSearchHLayout = new QHBoxLayout();
    qhblGroupHLayout = new QHBoxLayout();
    qhblPathLayout = new QHBoxLayout();

    qglGoodsGridLayout->setContentsMargins(0,0,0,0);
    qhblSearchHLayout->setContentsMargins(0,0,0,0);
    qhblPathLayout->setContentsMargins(0,0,0,0);
    qhblGroupHLayout->setContentsMargins(5,0,5,0);

    qgbSearchGroup = new QGroupBox(this);
    qgbSearchGroup->setStyleSheet("QGroupBox{"
                                     "background-color:black;"
                                     "border-radius:10px;"
                                  "}"
                                  );

    feFilterEdit = new FilterEdit(qgbSearchGroup);
    pwPathWidget = new PathWidget(qgbSearchGroup);
    tpTableProduct = new TableProduct(this);
    tsdTreeSearch = new TreeSearchDialog(this);
    slServiceLogo = new ServiceLogo(this);

    qhblPathLayout->addWidget(slServiceLogo,0,Qt::AlignLeft);
    qhblPathLayout->addWidget(pwPathWidget,9);

    qglGoodsGridLayout->addItem(qhblPathLayout,0,0,0,0,Qt::AlignTop);
    qglGoodsGridLayout->setAlignment(pwPathWidget,Qt::AlignLeft);
    qglGoodsGridLayout->addWidget(tpTableProduct,1,0,10,0);
    qglGoodsGridLayout->setSizeConstraint(QLayout::SetMaximumSize);

    qhblGroupHLayout->addWidget(feFilterEdit);

    qgbSearchGroup->setLayout(qhblGroupHLayout);
    qhblSearchHLayout->addWidget(qgbSearchGroup);
    qglGoodsGridLayout->addItem(qhblSearchHLayout,11,0);

    setLayout(qglGoodsGridLayout);

    connect(this,SIGNAL(connectCreateted()),pwPathWidget,SLOT(createConnectionManager()));
    connect(this,SIGNAL(connectCreateted()),slServiceLogo,SLOT(createConnectionManager()));
    connect(this,SIGNAL(connectCreateted()),tpTableProduct,SLOT(createConnectionManager()));
    connect(this,SIGNAL(connectCreateted()),slServiceLogo,SLOT(createConnectionManager()));
}

void GoodsWidget::setNetworkUpdate()
{

}

void GoodsWidget::createConnectionManager()
{
    gvioGoodsViewInfo = new GoodsViewInfoObject(this);
    //One Model
    //connect(gvioGoodsViewInfo,SIGNAL(readyGoodsTable(QAbstractItemModel*)),
    //        tpTableProduct,SLOT(setGoodsTableModel(QAbstractItemModel*)));
    connect(gvioGoodsViewInfo,SIGNAL(readyGoodsAndDirectory(QAbstractItemModel*,QAbstractItemModel*)),
            tpTableProduct,SLOT(setGoodsTableModel(QAbstractItemModel*,QAbstractItemModel*)));
    connect(feFilterEdit,SIGNAL(editTextChanged(QString)),
            gvioGoodsViewInfo,SIGNAL(needGoodsTable(QString)));
    connect(pwPathWidget,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)),
            this,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)));
    connect(slServiceLogo,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)),
            this,SIGNAL(clientServiceInfoOblectRegistered(ServiceInfoObject*)));
    connect(tpTableProduct,SIGNAL(clientGoodInfoOblectRegistered(GoodInfoObject*)),
            this,SIGNAL(clientGoodInfoOblectRegistered(GoodInfoObject*)));
    connect(tpTableProduct,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)),
            this,SIGNAL(clientPathInfoOblectRegistered(PathInfoObject*)));

    emit connectCreateted();
    emit clientGoodsViewInfoOblectRegistered(gvioGoodsViewInfo);
    gvioGoodsViewInfo->sendGoodsViewRequest(tr(""));
}

