#ifndef CONTENTWIDGET_H
#define CONTENTWIDGET_H

#include <QWidget>
#include <QGridLayout>

#include "orderwidget.h"
#include "logowidget.h"

#define ORDER_TYPE 0
#define SALE_TYPE 1
#define PROFILE_TYPE 2
#define REPORT_TYPE 3
#define SETTING_TYPE 4
#define SPLASH_TYPE 5

class ContentWidget : public QWidget
{
    Q_OBJECT;

private:
    QGridLayout *qglContentLayout;
    QWidget *qwCurrentWidget;

    int currentContentType;

public:

public:
    ContentWidget(QWidget *parent = 0);
    /**
      *methods of creating content
      */
    void createOrderContent();
    void createSaleContent();
    void createSplashContent();
    void createReportContent();
    void createSettingContent();
    void createProfileContent();
    void createContent(int contentTypeIndex);

public slots:
    void setState(int contentTypeIndex);

protected:
    void paintEvent(QPaintEvent *event);

};

#endif // CONTENTWIDGET_H
