#ifndef SIMPLESERVICE_H
#define SIMPLESERVICE_H

#include "qtsoap.h"
#include <QDebug>
#include <QObject>

class SimpleService:public QObject
{
    Q_OBJECT
public:
    ///Standart constructor
    SimpleService();
    SimpleService(const QString host, const int port, const QString action);
    SimpleService(const QString host, const int port);
public slots:

    ///Get response
    void getResponse();
    ///Submit request(standart)
    void submitRequest();
    ///Submit request with method
    void submitRequest(QString method);

signals:
    ///ResponseReady signal
    void ResponseIsReady();
protected:
    QtSoapHttpTransport http;
    QtSoapMessage response;
    QString path;
    QString host;
    int port;
    QString action;
};

#endif // SIMPLESERVICE_H
