/***************************************************************************

     demo.h
     -------------
     Copyright (c) 2010 by Zabirokhin Denis <denis.zabirokhin@gmail.com>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef DEMO_H
#define DEMO_H
#include "qtsoap.h"
#include <QDebug>
#include <QObject>
#include <QHttp>
#include <QStandardItemModel>

class demo : public QObject
{
    Q_OBJECT
public:
    demo();
public slots:
    void getResponse();
    void submitRequest();
    void submitRequest(QString method);
    void submitRequest(QString method, QVector<QString> *argName,
                       QVector<QString> *argValue);
    void getGoods();
    void getContractors();
    void getSellPoints();

    void sendOrder(QVector<QString> *argName,
                   QVector<QString> *argValue);

    void sendOrder(int id, int contractorId, int sellpointId, QVector<QString> *goodsId, QVector<int> *goodsCount);
    void getGoodTypes();
signals:

/// Get goods response is ready
    void getGoodsResponseReady();

/// Get contractors response is ready
    void getContractorsResponseReady();

/// Unknown response is ready
    void isReady(QStandardItemModel*);

/// Goods table is ready
    void getGoodsIsReady(QStandardItemModel*);

/// GoodTypes table is ready
    void getGoodTypesIsReady(QStandardItemModel*);

/// Get goodTypes response ready
    void getGoodTypesResponseReady();

/// Contractors table is ready
    void getContractorsIsReady(QStandardItemModel*);

/// Send order response signal. Int parametr is return code.
    void sendOrderResponse(int);

/// SellPoints table is ready
    void getSellPointsIsReady(QStandardItemModel*);

/// Get Sell Points response is ready
    void getSellPointsResponseReady();
    ///TODO: If we get error string in xml, we must start error handing
private:
    QStandardItemModel *data;
    QtSoapHttpTransport http;
    QtSoapMessage response;
};

#endif // DEMO_H
