#include "demo.h"

demo::demo()//:http(this)
{
    /// Connect signals to slots
    /// Standart connect: if response is ready
    connect(&http, SIGNAL(responseReady()), SLOT(getResponse()));
    connect(this,SIGNAL(getGoodsResponseReady()),this, SLOT(getGoods()));
    connect(this, SIGNAL(getContractorsResponseReady()), this, SLOT(getContractors()));
    connect(this, SIGNAL(getGoodTypesResponseReady()), this, SLOT(getGoodTypes()));
    connect(this, SIGNAL(getSellPointsResponseReady()), this, SLOT(getSellPoints()));

    /// Set host
    http.setHost("pmasc.karelia.ru", 7777);
}
void demo::submitRequest()
{
    //TODO: Default web-service to get all names of methods

    /// Create request
    QtSoapMessage request;

    /// Set request method
    request.setMethod(QtSoapQName("GetGoods", "http://tempuri.org/GetGoods"));

    /// Submit request
    http.setAction("http://tempuri.org/GetGoods");
    http.submitRequest(request, "/testws/Service.asmx");
}

void demo::submitRequest(QString method)
{
    qDebug() << "IN GET GOODS METHOD ------->";

    /// Set action
    http.setAction("http://tempuri.org/" + method);

    /// Request structure
    QtSoapMessage request;

    /// Set request method
    request.setMethod(QtSoapQName(method, "http://tempuri.org/" + method));

    /// Submit request
    http.submitRequest(request, "/testws/Service.asmx");
}

void demo::submitRequest(QString method,
                         QVector<QString> *argName,
                         QVector<QString> *argValue)
{
    /// Set action
    http.setAction("http://tempuri.org/" + method);

    /// Request structure
    QtSoapMessage request;

    /// Set request method
    request.setMethod(QtSoapQName(method, "http://tempuri.org/" + method));

    /// Add argument for new format web service order
//    for(int i = 0; i < argName->count(); i++) {
//        request.addMethodArgument(argName->at(i),
//                                  "", argValue->at(i));

    /// Create request string withold format order request
    QString temp_request_string;
    /// Fill parametrs
    for(int i = 0; i < 3; i++)
    {
        temp_request_string += argValue->at(i) +";";
    }
    for(int i = 3; i < argValue->count() - 1; i++)
    {
        temp_request_string += argValue->at(i) +",";
    }
    temp_request_string +=argValue->at(argValue->count()) + ";";


    /// Submit request
    http.submitRequest(request, "/testws/Service.asmx");
}

void demo::getResponse()
{
    qDebug() << "IN GET GOODS RESPONSE ------->";

    /// Get soap message
    const QtSoapMessage &resp = http.getResponse();

    qDebug() << resp.toXmlString();
    /// Change element
    response = resp;

    /// Get name of soap message
    QtSoapType type = resp.returnValue();

    /// Swith method by name of soap message
    /// If name is Goods
    if(type.name().name() == "GetGoodsResult")
        emit getGoodsResponseReady();
    /// If name is Contractors
    else if(type.name().name() == "GetContractorsResult")
        emit getContractorsResponseReady();
    /// If name is GoodTypes
    else if(type.name().name() == "GetGoodTypesResult")
        emit getGoodTypesResponseReady();
    /// If other:
    else
    {
        qDebug() << type.name().name();
        emit isReady(data);
    }
}

void demo::getGoods()
{
    /// Submit request to web service
    // submitRequest("GetGoods");

    /// Get root
    const QtSoapType &res = response.returnValue();

    /// Check valid of root
    if (!res.isValid()) {
        qDebug() << "Invalid return value";
        return;
    }

    qDebug() << "RESPONSE GET GOODS";
    /// Create temp data object
    QStandardItemModel *tmp_data = new QStandardItemModel(res.count(),8);

    for(int i = 0; i < res.count(); i++ )
    {

        /// Create data elements
        QStandardItem *id =
                new QStandardItem(QString("%1").
                                  arg(res[i]["ID"].toString()));
        QStandardItem *name =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Name"].toString()));
        QStandardItem *type =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Type"].toString()));

        QStandardItem *count =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Count"].toString()));
        QStandardItem *price =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Price"].toString()));
        QStandardItem *plan =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Plan"].toString()));
        QStandardItem *remain =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Remain"].toString()));
        QStandardItem *currencyid =
                new QStandardItem(QString("%1").
                                  arg(res[i]["CurrencyId"].toString()));
        QStandardItem *description =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Description"].toString()));

        /// Set id field in table
        tmp_data->setItem(i, 0, id);
        tmp_data->setItem(i, 1, name);
        tmp_data->setItem(i, 2, count);
        tmp_data->setItem(i, 3, price);
        tmp_data->setItem(i, 4, type);
        tmp_data->setItem(i, 5, currencyid);
        tmp_data->setItem(i, 6, remain);
        tmp_data->setItem(i, 7, description);
    }

    /// Change point to demo::data
    data = tmp_data;

    /// Emit signal if goods ready
    emit getGoodsIsReady(data);
}



void demo::getContractors()
{
    //    submitRequest("GetContractors");

    /// Get root
    const QtSoapType &res = response.returnValue();

    /// Check valid of root
    if (!res.isValid()) {
        qDebug() << "Invalid return value";
        return;
    }

    /// Create temp data object
    QStandardItemModel *tmp_data =
            new QStandardItemModel(res.count(),4);

    for(int i = 0; i < res.count(); i++ )
    {
        /// Create data elements
        QStandardItem *id =
                new QStandardItem(QString("%1")
                                  .arg(res[i]["ID"].toString()));
        QStandardItem *name =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Name"].toString()));
        QStandardItem *phone =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Phone"].toString()));
        QStandardItem *address =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Address"].toString()));


        /// Set id field in table
        tmp_data->setItem(i, 0, id);
        tmp_data->setItem(i, 1, name);
        tmp_data->setItem(i, 2, phone);
        tmp_data->setItem(i, 2, address);

    }
    /// Change point to demo::data
    data = tmp_data;
    emit getContractorsIsReady(data);
}

void demo::sendOrder(QVector<QString> *argName, QVector<QString> *argValue)
{
    submitRequest("SendOrder", argName, argValue);
}

void demo::getGoodTypes()
{
    ///Get root
    const QtSoapType &res = response.returnValue();

    /// Check valid of root
    if (!res.isValid()) {
        qDebug() << "Invalid return value";
        return;
    }

    ///TODO: Change magic numbers
    /// Create temp data object
    QStandardItemModel *tmp_data =
            new QStandardItemModel(res.count(), 3);

    for(int i = 0; i < res.count(); i++ )
    {
        /// Create data elements
        QStandardItem *id =
                new QStandardItem(QString("%1")
                                  .arg(res[i]["ID"].toString()));
        QStandardItem *name =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Name"].toString()));
        QStandardItem *rootid =
                new QStandardItem(QString("%1").
                                  arg(res[i]["RootId"].toString()));


        /// Set id field in table
        tmp_data->setItem(i, 0, id);
        tmp_data->setItem(i, 1, name);
        tmp_data->setItem(i, 2, rootid);

    }
    /// Change point to demo::data
    data = tmp_data;
    emit getGoodTypesIsReady(data);
}

void demo::getSellPoints()
{
    ///Get root
    const QtSoapType &res = response.returnValue();

    /// Check valid of root
    if (!res.isValid()) {

#ifdef DEBUG
        qDebug() << "Invalid return value";
#endif
        return;
    }

    ///TODO: Change magic numbers
    /// Create temp data object
    QStandardItemModel *tmp_data =
            new QStandardItemModel(res.count(), 8);

    for(int i = 0; i < res.count(); i++ )
    {
        /// Create data elements
        QStandardItem *id =
                new QStandardItem(QString("%1")
                                  .arg(res[i]["ID"].toString()));
        QStandardItem *name =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Name"].toString()));
        QStandardItem *contractorid =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Contractor_ID"].toString()));
        QStandardItem *category =
                new QStandardItem(QString("%1")
                                  .arg(res[i]["Category"].toString()));
        QStandardItem *type =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Type"].toString()));
        QStandardItem *address =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Address"].toString()));
        QStandardItem *phone =
                new QStandardItem(QString("%1")
                                  .arg(res[i]["Phone"].toString()));
        QStandardItem *comment =
                new QStandardItem(QString("%1").
                                  arg(res[i]["Comment"].toString()));

        /// Set id field in table
        tmp_data->setItem(i, 0, id);
        tmp_data->setItem(i, 1, name);
        tmp_data->setItem(i, 2, contractorid);
        tmp_data->setItem(i, 3, category);
        tmp_data->setItem(i, 4, type);
        tmp_data->setItem(i, 5, address);
        tmp_data->setItem(i, 6, phone);
        tmp_data->setItem(i, 7, comment);

    }
    /// Change point to demo::data
    data = tmp_data;
    /// Send signal that sellPoints is readyzzzz
    emit getSellPointsIsReady(data);
}

void demo::sendOrder(int id, int contractorId, int sellpointId, QVector<QString> *goodsId, QVector<int> *goodsCount)
{
   /// Create vectors with data
   QVector<QString> tmp_argValues;
   QVector<QString> tmp_argNames;

   /// Fill this vectors

#ifdef DEBUG
   qDebug() << "ACTION: Push Order ID";
#endif
   /// Push id
    tmp_argNames.push_back("ID");
    tmp_argValues.push_back(QString::number(id));

#ifdef DEBUG
   qDebug() << "ACTION: Push Order Contractor ID";
#endif
    /// Push contractor id
    tmp_argNames.push_back("ContractorID");
    tmp_argValues.push_back(QString::number(contractorId));

#ifdef DEBUG
   qDebug() << "ACTION: Push Order SellPoint ID";
#endif
    /// Push sellpoint id
    tmp_argNames.push_back("SellPointID");
    tmp_argValues.push_back(QString::number(sellpointId));

#ifdef DEBUG
   qDebug() << "ACTION: Start push Order Goods";
#endif
    /// Push list of Goods
    for(int i = 0; i < goodsId->count(); i++)
    {

#ifdef DEBUG
   qDebug() << "ACTION: Insert special symbol ~";
#endif
        /// Insert simbole
        tmp_argNames.push_back("~");
        tmp_argValues.push_back("~");

#ifdef DEBUG
        qDebug() << "ACTION: Push name of root object ";
#endif
        /// Push name of root object
        tmp_argNames.push_back(("Goods"));
        tmp_argValues.push_back("root");

#ifdef DEBUG
        qDebug() << "ACTION: Push name of object ";
#endif
        /// Push name of object
        tmp_argNames.push_back("ProduceDetail");
        tmp_argValues.push_back("object");

#ifdef DEBUG
        qDebug() << "ACTION: Push name and value ";
#endif
        /// Push value and name of object
        tmp_argNames.push_back("ID");
        tmp_argValues.push_back(goodsId->at(i));

        tmp_argNames.push_back("count");
        tmp_argValues.push_back("goodsCount->at(i)");
    }
    QString method = "SendOrderDetail";
    submitRequest(method, &tmp_argNames, &tmp_argValues );
}
