/***************************************************************************

     order.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef SELLPOINT_H
#define SELLPOINT_H

#include <QString>
#include "../database/mdb.h"

/**
 * @class Selling Point model class
 * @short Selling Point model class
 *
 * Class provides functions and variables to work with
 * information about selling point
 *
 * @author Andrianov Pavel
 */

class SellPoint
{
public:
    /// Standard constructor
    SellPoint();

    /// Returns the identificator of this selling point in the database
    int getId();

    /// Sets the identificator of this selling point in the database
    void setId(int);

    /// Returns the name of this selling point
    QString getName();

    /// Get address
    QString getAddress();

    /// Set address
    void setAddress(QString new_address);

    /// Converts int to QString
    QString toQString(int);

    /// Converts double to QString
    QString toQString(double);

    /// Set the name
    void setName(QString);

    /// Loads the information from the database
    /**
     * @brief Create the sell point using loading from database
     * Load sell point from database
     * @param db pointer to the database module object
     * @param id identifier of sell point in the database
     * @see Mdb::find()
     */
    SellPoint(Mdb* db, int id);

    /// Saves the sell point to database
    /**
     * @brief Save sell point to database
     * @param db pointer to the database module object
     */
    void set(Mdb* db);

    /// Get table name
    /**
     * @brief Get table name
     * Get table name in the database, where sell points is located
     * @return name of the table
     */
    QString tableName();

    int getContractorId();
    QString getCategory();
    QString getType();
    QString getComment();
    QString getPhone();

    void setContractorId(int);
    void setCategory(QString);
    void setType(QString);
    void setComment(QString);
    void setPhone(QString);

protected:
    /// Identifier of the sell point in the database
    int id;

    /// Name of the sell point
    QString name;

    /// Address of the sell point
    QString address;

    int contractor_id;

    QString phone;
    QString category;
    QString type;
    QString comment;
};

#endif // SELLPOINT_H
