#include "sellpoint.h"

SellPoint::SellPoint()
{
    this->id =  NEW_ID;
}

int SellPoint::getId()
{
    return id;
}

void SellPoint::setId(int new_id)
{
    this->id = id;
}

QString SellPoint::getName()
{
    return name;
}

QString SellPoint::getAddress()
{
    return this->address;
}

void SellPoint::setAddress(QString new_address)
{
    this->address = new_address;
}

void SellPoint::setName(QString new_name)
{
    this->name = new_name;
}

QString SellPoint::tableName()
{
    return QString::QString("tblSellPoints");
}

SellPoint::SellPoint(Mdb *mdb, int id)
{
    /// Find values with such id in database
    QSqlQueryModel* model = mdb->find(this->tableName(),id);

    /// Parse fields
    this->id = id;
    this->name = model->record(0).value(2).toString();
    this->address = model->record(0).value(5).toString();
}

QString SellPoint::toQString(int value)
{
    QString string = QString("%1").arg(value);
    return string;
}

QString SellPoint::toQString(double value)
{
    QString string = QString("%1").arg(value);
    return string;
}

void SellPoint::set(Mdb *mdb)
{
    QVector<QString> fieldsValue;

    fieldsValue.push_back(toQString(this->id));
    fieldsValue.push_back(toQString(this->contractor_id));
    fieldsValue.push_back(this->name);
    fieldsValue.push_back(this->category);
    fieldsValue.push_back(this->type);
    fieldsValue.push_back(this->address);
    fieldsValue.push_back(this->phone);
    fieldsValue.push_back(this->comment);

    /// If this is the new sell point
    if ( this->id == NEW_ID )
    {
        /// Get the id
        this->id = mdb->getUnusedId(this->tableName());
        fieldsValue[0] = toQString(this->id);

        /// Insert this good into mdb
        mdb->addToDb(this->tableName(), fieldsValue);
    }
    else
    {
        /// Creating additional vector with field names
        QVector<QString> fieldsName;

        /// Fill with names
        fieldsName.push_back("id");
        fieldsName.push_back("contrid");
        fieldsName.push_back("name");
        fieldsName.push_back("category");
        fieldsName.push_back("type");
        fieldsName.push_back("address");
        fieldsName.push_back("phone");
        fieldsName.push_back("comment");

        /// Update this good in the database
        mdb->addToDb(this->tableName(),&fieldsValue,&fieldsName,this->id);
    }
}

int SellPoint::getContractorId(){
    return this->contractor_id;
}

QString SellPoint::getPhone(){
    return this->phone;
}

void SellPoint::setPhone(QString new_phone){
    this->phone = new_phone;
}

QString SellPoint::getCategory(){
    return this->category;
}

QString SellPoint::getType(){
    return this->type;
}

QString SellPoint::getComment(){
    return this->comment;
}

void SellPoint::setContractorId(int new_contractor_id){
    this->contractor_id = new_contractor_id;
}

void SellPoint::setCategory(QString new_category){
    this->category = new_category;
}

void SellPoint::setType(QString new_type){
    this->type = new_type;
}

void SellPoint::setComment(QString new_comment){
    this->comment = new_comment;
}

