/***************************************************************************

     order.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef SELLFIRM_H
#define SELLFIRM_H

#include <QString>
#include "../database/mdb.h"

/**
 * @class Selling Firm model class
 * @short Selling Firm model class
 *
 * Class provides functions and variables to work with
 * information about selling firm
 *
 * @author Andrianov Pavel
 */

class SellFirm
{
public:
    SellFirm();
    int getId();
    QString getName();
    void setId(int);
    void setName(QString);
    SellFirm(Mdb* db, int id);
    QString tableName();
private:
    int id;
    QString name;
};

#endif // SELLFIRM_H
