/***************************************************************************

     sale.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "sale.h"

Sale::Sale() : Document()
{
    orderid = 0;
    tax = 0;
}

Sale::Sale(Sale* sale):Document( sale->id, sale->contrid, sale->sellpointid, sale->payid,
                                 sale->priceid, sale->delivid, sale->post, sale->date,
                                 sale->discount, sale->sellfirmid, sale->contractid)
{
    this->orderid = sale->orderid;
    this->tax = sale->tax;
}

Sale::Sale(int id, int contrid, int sellpointid, int payid, int priceid,
           bool delivid, bool post, double discount, QString date,
           int sellfirmid, bool tax, int contractid, int orderid
           ): Document( id, contrid, sellpointid, payid,
                        priceid, delivid, post, date, discount,
                        sellfirmid, contractid)
{
    this->orderid = orderid;
    this->tax = tax;
}
