/***************************************************************************

     order.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "order.h"

///// Standart constructor with all parametrs.
//// TODO: add modelclasses parameters
//Order::Order( int id, int contrid, int sellpointid, int payid, int priceid,
//              int delivid, bool post, QString date, QString payupto,
//              double discount, int sellfirmid, QString comment, QString alt_address,
//              int contractid
//              )
//{
//    this->id = id;
//    this->contrid = contrid;
//    this->sellpointid = sellpointid;
//    this->payid = payid;
//    this->priceid = priceid;
//    this->delivid = delivid;
//    this->post = post;
//    this->date = date;
//    this->discount = discount;
//    this->sellfirmid = sellfirmid;
//    this->contractid = contractid;
//    this->payupto = payupto;
//    this->comment = comment;
//    this->alt_address = alt_address;
//}

Order::Order()
{
    this->id = NEW_ID;
}

void Order::addGood(Good* good, int quantity)
{
    GoodRecord record; 

    record.good = good;

    record.quantity = quantity;

    (this->Goods).push_back(record);
}

void Order::setId(int new_id){
    this->id = new_id;
}

Good* Order::goodAt(int at)
{
    GoodRecord record;

    record = Goods[at];

    return record.good;
}

//void Order::removeGood(int index, int quantity)
//{
//    if (Goods[index].quantity > quantity) {
//        Goods[index].quantity-=quantity;
//    } else {
//        Goods.remove(index);
//    }
//}

void Order::removeGood(int index)
{
    Goods.remove(index);
}

int Order::numberOfGoods() const
{
    return Goods.size();
}

int Order::quantityOf(int at) const
{
    GoodRecord record;

    record = Goods[at];

    return record.quantity;
}

bool Order::changePosted()
{
    if (this->post == true) {
        this->setUnPosted();
    } else {
        this->setPosted();
    }

    return this->post;
}

QString Order::toQString(int value)
{
    QString string = QString("%1").arg(value);
    return string;
}

QString Order::toQString(double value)
{
    QString string = QString("%1").arg(value);
    return string;
}

Order::Order(Mdb* mdb, int id)
{
    /// Find values with such id in database
    QSqlQueryModel* model = mdb->find(this->tableName(),id);

    //TODO: COnstructors for all model classes (from DB and Soap)
    /// Parse fields
    this->id = id;
    this->contractor = new Contractor(mdb, model->record(0).value(1).toInt());
    this->sell_point = new SellPoint(mdb, model->record(0).value(2).toInt());
    //this->pay_type->get(mdb, model->record(0).value(3).toInt());
    //this->price_type->get(mdb, model->record(0).value(4).toInt());
    //this->delivery_type->get(mdb, model->record(0).value(5).toInt());
    this->post = model->record(0).value(6).toBool();
    this->discount = model->record(0).value(7).toDouble();
    this->date = model->record(0).value(8).toDate();
    this->payupto = model->record(0).value(9).toDate();
    this->alt_address = model->record(0).value(10).toString();
    //this->sell_firm->get(mdb, model->record(0).value(11).toInt());
    this->comment = model->record(0).value(12).toString();
    //this->contract->get(mdb, model->record(0).value(13).toInt());

    /// Get the ordered goods
    /// Find all records about ordered goods
    QVector<QString> fieldsValue;
    QVector<QString> fieldsName;

    fieldsName.push_back("orderid");
    fieldsValue.push_back(toQString(this->id));

    model = mdb->find("tblOrdered",&fieldsName,&fieldsValue);

    /// Add goods by that ordered records
    for (int i=0;i<model->rowCount();i++)
    {
        Good* good = new Good(mdb,model->record(i).value(2).toInt());
        addGood(good,model->record(i).value(3).toInt());
    }
}

void Order::set(Mdb* mdb)
{
    QVector<QString> fieldsValue;

    /// Creating additional vector with field names
    QVector<QString> fieldsName;

    fieldsValue.push_back(toQString(this->id));
    fieldsValue.push_back(toQString(this->contractor->getId()));
    fieldsValue.push_back(toQString(this->sell_point->getId()));
    fieldsValue.push_back(toQString(this->pay_type->getId()));
    fieldsValue.push_back(toQString(this->price_type->getId()));
    fieldsValue.push_back(toQString(this->delivery_type->getId()));
    fieldsValue.push_back(toQString(this->post));
    fieldsValue.push_back(toQString(this->discount));
    fieldsValue.push_back(this->date.toString());
    fieldsValue.push_back(this->payupto.toString());
    fieldsValue.push_back(this->alt_address);
    fieldsValue.push_back(toQString(this->sell_firm->getId()));
    fieldsValue.push_back(this->comment);
    fieldsValue.push_back(toQString(this->contract->getId()));

    /// If this is the new order
    if ( this->id == NEW_ID )
    {
        /// Get the id
        this->id = mdb->getUnusedId(this->tableName());
        fieldsValue[0] = toQString(this->id);

        /// Insert this good into mdb
        mdb->addToDb(this->tableName(), fieldsValue);
    }
    else
    {
        /// Fill with names
        fieldsName.push_back("id");
        fieldsName.push_back("contrid");
        fieldsName.push_back("sellpointid");
        fieldsName.push_back("payid");
        fieldsName.push_back("priceid");
        fieldsName.push_back("delivid");
        fieldsName.push_back("post");
        fieldsName.push_back("discount");
        fieldsName.push_back("date");
        fieldsName.push_back("payupto");
        fieldsName.push_back("alt_address");
        fieldsName.push_back("sellfirmid");
        fieldsName.push_back("comment");
        fieldsName.push_back("contractid");

        /// Update this good in the database
        mdb->addToDb(this->tableName(),&fieldsValue,&fieldsName,this->id);
    }

    /// Adding goods
    for (int i=0;i<this->numberOfGoods();i++)
    {
        fieldsValue.clear();
        fieldsValue.push_back(toQString(mdb->getUnusedId("tblOrdered")));
        fieldsValue.push_back(toQString(this->id));
        fieldsValue.push_back(toQString(this->goodAt(i)->getId()));
        fieldsValue.push_back(toQString(this->quantityOf(i)));
        mdb->addToDb("tblOrdered",fieldsValue);
    }
}

QString Order::getComment()
{
    return this->comment;
}

QString Order::getAltAddress()
{
    return this->alt_address;
}

Contractor* Order::getContractor()
{
    return this->contractor;
}

Contract* Order::getContract()
{
    return this->contract;
}

QDate* Order::getDate()
{
    return &this->date;
}

QString Order::getDateString()
{
    // TODO: do this
    return this->date.toString();
}

DeliveryType* Order::getDeliveryType()
{
    return this->delivery_type;
}

double Order::getDiscount()
{
    return this->discount;
}

int Order::getId()
{
    return this->id;
}

PayType* Order::getPayType()
{
    return this->pay_type;
}

QDate* Order::getPayUpTo()
{
    return &this->payupto;
}

PriceType* Order::getPriceType()
{
    return this->price_type;
}

SellFirm* Order::getSellFirm()
{
    return this->sell_firm;
}

SellPoint* Order::getSellPoint()
{
    return this->sell_point;
}

bool Order::isNew()
{
    if (this->id == NEW_ID) {
        return true;
    } else {
        return false;
    }
}

QStandardItemModel* Order::getGoods()
{
    QStandardItemModel* model = new QStandardItemModel(this->numberOfGoods(),3);

    for (int i=0;i<this->numberOfGoods();i++)
    {
        QStandardItem *item0 = new QStandardItem(QString("%0").arg(this->goodAt(i)->getId()));
        model->setItem(i, 0, item0);
        QStandardItem *item1 = new QStandardItem(QString("%0").arg(this->goodAt(i)->getName()));
        model->setItem(i, 1, item1);
        QStandardItem *item2 = new QStandardItem(QString("%0").arg(this->quantityOf(i)));
        model->setItem(i, 2, item2);
    }

    return model;
}

bool Order::isValid()
{
    return true;
}

void Order::setContractor(Contractor* contractor)
{
    this->contractor = contractor;
}

void Order::setSellPoint(SellPoint* sell_point)
{
    this->sell_point = sell_point;
}

void Order::setPayType(PayType* pay_type)
{
    this->pay_type = pay_type;
}

void Order::setPriceType(PriceType* price_type)
{
    this->price_type = price_type;
}

void Order::setContract(Contract* contract)
{
    this->contract = contract;
}

void Order::setDeliveryType(DeliveryType* delivery_type)
{
    this->delivery_type = delivery_type;
}

void Order::setPosted()
{
    /// See, if all needed fields are fulled

    /// If that, make it posted
    this->post = true;
}

void Order::setUnPosted()
{
    this->post = false;
}

void Order::setDiscount(double discount)
{
    this->discount = discount;
}

void Order::setDate(QDate* date)
{
    this->date = *date;
}

void Order::setPayUpTo(QDate* date)
{
    this->payupto = *date;
}

QString Order::tableName()
{
    return "tblOrder";
}

void Order::setSellFirm(SellFirm* sell_firm)
{
    this->sell_firm = sell_firm;
}

void Order::setComment(QString comment)
{
    this->comment = comment;
}

void Order::setAltAddress(QString alt_address)
{
    this->alt_address = alt_address;
}

QString getTableName()
{
    return QString::QString("tblOrders");
}

void Order::set(soapclient *client)
{
/*
    QVector<QString> fieldsValue;

    /// Creating additional vector with field names
    QVector<QString> fieldsName;

    fieldsValue.push_back(toQString(this->id));
    fieldsValue.push_back(toQString(this->contractor->getId()));
    fieldsValue.push_back(toQString(this->sell_point->getId()));
    fieldsValue.push_back(toQString(this->pay_type->getId()));
    fieldsValue.push_back(toQString(this->price_type->getId()));
    fieldsValue.push_back(toQString(this->delivery_type->getId()));
    fieldsValue.push_back(toQString(this->post));
    fieldsValue.push_back(toQString(this->discount));
    fieldsValue.push_back(this->date.toString());
    fieldsValue.push_back(this->payupto.toString());
    fieldsValue.push_back(this->alt_address);
    fieldsValue.push_back(toQString(this->sell_firm->getId()));
    fieldsValue.push_back(this->comment);
    fieldsValue.push_back(toQString(this->contract->getId()));

    /// If this is the new order
    if ( this->id == NEW_ID )
    {
        /// Get the id
        this->id = mdb->getUnusedId(this->tableName());
        fieldsValue[0] = toQString(this->id);

        /// Insert this good into mdb
        mdb->addToDb(this->tableName(), fieldsValue);
    }
    else
    {
        /// Fill with names
        fieldsName.push_back("id");
        fieldsName.push_back("contrid");
        fieldsName.push_back("sellpointid");
        fieldsName.push_back("payid");
        fieldsName.push_back("priceid");
        fieldsName.push_back("delivid");
        fieldsName.push_back("post");
        fieldsName.push_back("discount");
        fieldsName.push_back("date");
        fieldsName.push_back("payupto");
        fieldsName.push_back("alt_address");
        fieldsName.push_back("sellfirmid");
        fieldsName.push_back("comment");
        fieldsName.push_back("contractid");

        /// Update this good in the database
        mdb->addToDb(this->tableName(),&fieldsValue,&fieldsName,this->id);
    }

    /// Adding goods
    for (int i=0;i<this->numberOfGoods();i++)
    {
        fieldsValue.clear();
        fieldsValue.push_back(toQString(mdb->getUnusedId("tblOrdered")));
        fieldsValue.push_back(toQString(this->id));
        fieldsValue.push_back(toQString(this->goodAt(i)->getId()));
        fieldsValue.push_back(toQString(this->quantityOf(i)));
        mdb->addToDb("tblOrdered",fieldsValue);
    }
    */
}
