/***************************************************************************

     goodstype.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef GOODSTYPE_H
#define GOODSTYPE_H

#include "../database/mdb.h"
#include "good.h"

/**
 * @class Goods type model class
 * @short Goods type model class
 *
 * Class provides functions and variables to work with
 * information about types of goods
 *
 * Stores the types tree
 *
 * @author Andrianov Pavel
 */
class GoodsType
{
public:
    /// Loads the information from the database
    /**
     * @brief Create the good using loading from database
     * Load goods type tree from database
     * @param db pointer to the database module object
     * @param id identifier of good in the database
     * @see Mdb::find()
     */
    GoodsType();
    GoodsType(Mdb* db, int id);

    /// Saves types tree to database
    /**
     * @brief Save types tree to database
     * @param db pointer to the database module object
     */

    void set(Mdb *mdb);

    /// Returns the id of parent type in db
    int getParentId();

    /// Returns the name of the table in db, which contains types of goods
    QString tableName();

    /// Returns the name of the type
    QString getName();

    void setName(QString tmp_name);
    void setParentId(int tmp_parent_id);
    void setId(int tmp_id);

    /// Returns the id of the type in database
    int getId();

    void get();

    // TODO: Add other functionality
private:
    int id;
    int parent_id;
    QString name;
};

#endif // GOODSTYPE_H
