/***************************************************************************

     goodstype.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "goodstype.h"

GoodsType::GoodsType()
{

}

GoodsType::GoodsType(Mdb* db, int id)
{
    /// Find values with such id in database
    QSqlQueryModel* model = db->find(this->tableName(),id);

    /// Parse fields
    this->id = id;
    this->name = model->record(0).value(1).toString();
    this->parent_id = model->record(0).value(2).toInt();
}

int GoodsType::getParentId()
{
    return this->parent_id;
}

void GoodsType::setId(int tmp_id)
{
    id = tmp_id;
}

void GoodsType::setName(QString tmp_name)
{
    name = tmp_name;
}

void GoodsType::setParentId(int tmp_parent_id)
{
    parent_id = tmp_parent_id;
}

int GoodsType::getId()
{
    return this->id;
}

QString GoodsType::getName()
{
    return this->name;
}

QString GoodsType::tableName()
{
    return QString::QString("tblGoodsType");
}


void GoodsType::set(Mdb *mdb)
{
    QVector<QString> fieldsValue;

    /// QString tranformations of parametrs
    QString tmp_id_string = QString("%1").arg(this->id);
    QString tmp_parent_id_string = QString("%1").arg(this->parent_id);

    qDebug() << "Tranformation finished";
    fieldsValue.push_back(tmp_id_string);
    fieldsValue.push_back(this->name);
    fieldsValue.push_back(tmp_parent_id_string);
    qDebug() << "push Values finished";
    /// If this is the new good
//    if ( this->id == NEW_ID )
//    {
        qDebug() << "In new ID";
        /// Get the id
//        this->id = mdb->getUnusedId(this->tableName());
        fieldsValue[0] =  tmp_id_string;

        /// Insert this good into mdb
        mdb->addToDb(this->tableName(), fieldsValue);
        qDebug() << "Add to db new Id finished";
/*    }
    else
    {
        /// Creating additional vector with field names
        QVector<QString> fieldsName;

        /// Fill with names
        fieldsName.push_back("id");
        fieldsName.push_back("name");
        fieldsName.push_back("rootid");
        qDebug() << "Push back old Id finished";
        /// Update this good in the database
        mdb->addToDb(this->tableName(),&fieldsValue,&fieldsName,this->id);
        qDebug() << "Thats OK";
    }
*/
}
