/***************************************************************************

     goodstree.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef GOODSTREE_H
#define GOODSTREE_H

#include "goodstype.h"
#include "good.h"
#include <QTreeView>
#include <QStandardItemModel>
#include "../database/mdb.h"

// TODO: think about structure of data and methods
class GoodsTree
{
public:
    GoodsTree(Mdb* db);

    GoodsType* getRoot();

    /// Get the list of goods by this type
    /**
     * @brief Get the list of private goods by this type
     * @return list of goods
     **/
    QSqlQueryModel* getGoods(GoodsType* type);

    /// Get the list of down-level types by this type
    /**
     * @brief Get the list of down-level types by this type
     * @return list of types
     **/
    QAbstractItemModel* getTypes(GoodsType* type);

//    /// Get the list of down-level types and goods by this type
//    /**
//     * @brief Get the list of down-level types and goods by this type
//     * @return list of types and goods
//     **/
//    QStandardItemModel* getSub(GoodsType* type);

    /// Get path from the root downto this type
    /**
     * @brief Get path to this type
     * @return list of types
     **/
    QStandardItemModel* getPath(GoodsType* type);

    /// Filter the tree by this filter
    void setFilter(QString filter);

    // TODO: >>>>
    /// Get list of previosly used filters
    QStandardItemModel* getFilterList();

    QString getCurrentFilter();

    // TODO: make private
    QStandardItemModel* errorModel();

private:
    // TODO: make private
    QString current_filter;

private:
    QStack<int>* getInitTypesIds(QString filter);

    void clearTree();

    Mdb* mdb;

    struct TreeNode {
        GoodsType* type;  /// link to type
        int parent_index; /// index of the parent type node in tree
    };
    typedef struct TreeNode TreeNode;

    QVector<TreeNode> tree;

    // TODO: make were the local dynamic array in setFilter function
    int were[100];
};

#endif // GOODSTREE_H
