/***************************************************************************

     document.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/
#ifndef DOCUMENT_H
#define DOCUMENT_H

#include "good.h"
#include "contractor.h"
#include "contract.h"
#include "deliverytype.h"
#include "goodstype.h"
#include "ordered.h"
#include "paytype.h"
#include "pricetype.h"
#include "sellfirm.h"
#include "sellpoint.h"

#include <QVector>

#define NEW_DOCUMENT_ID -1

/**
 * @class Document model class
 * @short Document model class
 *
 * Class provides functions and variables to work with
 * information about documents, witch generate order and sale classes
 *
 * @author Andrianov Pavel, Nikiforov Artem
 */
class Document
{
    /// @struct record of the booked good with its quantity
    struct GoodRecord
    {
        Good* good;
        int quantity;
    };

protected:
    /// Constructor
    Document();

    /// Standart constructor with all avaliable fields
    Document( int id, int contrid, int sellpointid, int payid, int priceid, int delivid, bool post, QString date, double discount, int sellfirmid, int contractid);

    /// Goods, that was booked in this document
    QVector<GoodRecord> Goods;

public:
    /// Add good to document
    /**
     * @brief Adds good in the document
     * @param good, good*, a name of good
     * @param quantity, int, quantity of goods booked in the document
     **/
    void addItem(Good*, int quantity = 1);
    //void removeItem(int index, int quantity = 1);

    /// Remove good from document
    /**
     * @brief Removes good from our document
     * @param index, int, index of good, that should be removed
     **/
    void removeItem(int index);

    /// Get the number of goods, booked in document
    /**
     *@brief Gets number of goods, booked in the document
     *@return int, number of goods
     **/
    int numberOfItem() const;

    /// Get the good, booked in this position
    /**
     *@brief Returns name of good, booked in the document, by index
     *@param at, int, index of booked good
     *@return good*, name of booked good
     **/
    Good* itemAt (int);

    /// Get the quantity of good, booked in this position
    /**
     *@brief Returns quantity of good, booked in the document, under index
     *@param at, int, index of booked good
     *@return int, quantity of booked good
     **/
    int quantityOf(int) const;

    int getId();
    Contractor* getContractor();
    SellPoint* getSellPoint();
    PayType* getPayType();
    PriceType* getPriceType();
    DeliveryType* getDeliveryType();


protected:
    /// Identifier of the document in the mobile database
    int id;

    // TODO: delete it, this field dublicates the contractor field.
    /// Identifier of the contractor
    int contrid;

    /// Contractor
    Contractor* contractor;

    /// Identifier of the sell point in database
    int sellpointid;

    /// Identifier of the type of pay in database
    int payid;

    /// Identifier of the type of price in database
    int priceid;

    /// Identifier of the mode of delivery
    int delivid;

    /// Identifier if the document is posted or not
    /**
      * @note In the posted documents booked goods
      * decreases the remains of this good in the stores
      */
    bool post;

    /// Discount for the document
    double discount;

    /// Date when the order/sale must be made
    QString date;

    /// Identifier of the contract in the database
    int contractid;

    /// Identifier of sellfirm
    int sellfirmid;
};

#endif // DOCUMENT_H
