/***************************************************************************

     document.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "document.h"

Document::Document()
{
    this->id = NEW_DOCUMENT_ID;
    this->contrid = 0;
    this->sellpointid = 0;
    this->payid = 0;
    this->priceid = 0;
    this->delivid = 0;
    this->post = 0;
    this->date = "";
    this->sellfirmid = 0;
    this->discount = 0.0;
    this->contractid = 0;
}

Document::Document( int id, int contrid, int sellpointid, int payid,
                    int priceid, int delivid, bool post, QString date,
                    double discount, int sellfirmid, int contractid)
{
    this->id = id;
    this->contrid = contrid;
    this->sellpointid = sellpointid;
    this->payid = payid;
    this->priceid = priceid;
    this->delivid = delivid;
    this->post = post;
    this->date = date;
    this->discount = discount;
    this->sellfirmid = sellfirmid;
    this->contractid = contractid;
}

void Document::addItem(Good* good, int quantity)
{
    GoodRecord record;

    record.good = good;
    record.quantity = quantity;

    (this->Goods).push_back(record);
}

Good* Document::itemAt(int at)
{
    GoodRecord record;

    record = Goods[at];

    return record.good;
}

//void Document::removeItem(int index, int quantity)
//{
//    if (Goods[index].quantity > quantity) {
//        Goods[index].quantity-=quantity;
//    } else {
//        Goods.remove(index);
//    }
//}

void Document::removeItem(int index)
{
    Goods.remove(index);
}

int Document::numberOfItem() const
{
    return Goods.size();
}

int Document::quantityOf(int at) const
{
    GoodRecord record;

    record = Goods[at];

    return record.quantity;
}
