/***************************************************************************

     mdb.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>
                       and Zabirokhin Denis <denis.zabirokhin@gmail.com>
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "mdb.h"

// TODO: query.isActive() and error codes
Mdb::Mdb()
{

    ///Initialize

    ///Select type of database (this is QSQLITE)
    db = QSqlDatabase::addDatabase("QSQLITE");

    #if defined(Q_OS_LINUX)
        db.setDatabaseName(QDir::homePath()+"/.mobiletrade/local.db");
        qDebug()<<QDir::homePath()+"/.mobiletrade/local.db";
    #elif defined(Q_OS_MAC)
        app.exit();
        return 0;
    #elif defined(Q_OS_WIN)
        db.setDatabaseName("../res/local.db");
    #endif
    ///Set database name
    ///Open database, error handler
    if (!db.open()) {
        ///Warning message
        qDebug() << "not connected:" << db.lastError().text();
    }
}
int Mdb::status()
{
}

int Mdb::addToDb( const QString name, const QVector<QString> fields)
{
    QString sqlQuery;

    ///Prepare query string for add to DB
    sqlQuery = "insert into "+name+" values(";

    ///Construct sql request
    for(int i = 0;  i < fields.size() - 1; i++)    {
        sqlQuery += "'"+fields.at(i)+"',";
    }

    ///Last field in sql request without ,
    sqlQuery += "'"+ fields.at(fields.size() - 1)+"')";

    ///End construct sql request
    sqlQuery +=";";

    ///Exec query string and return exit code.
    return this->exec(sqlQuery);
}

int Mdb::addToDb(const QString name,
                 const QVector<QString> *fieldValue,
                 const QVector<QString> *fieldName,
                 const long id)
{
    QString sqlQuery;

    ///Set count fields
    int size = fieldValue->size();

    ///Convert id from int to QString
    QString idString = QString("%1").arg(id);

    ///Set update command in sql request
    sqlQuery = "update "+name+" set ";

    ///Construct sql request
    for(int i = 0; i < size - 1; i++)    {
        sqlQuery += fieldName->at(i) + "= '" + fieldValue->at(i) + "' ,";
    }
    sqlQuery += fieldName->at(size) + "= '" + fieldValue->at(size)+ "' ";
    sqlQuery += "where id='" + idString + "'";

    ///End construct sql request
    sqlQuery +=";";

    //TODO: >>> exec and return
}

int Mdb::getUnusedId(QString name)
{
    QString sqlQuery;
    QSqlQueryModel *model = new QSqlQueryModel();

    sqlQuery = "SELECT MAX("+name+".id)+1 FROM "+name+";";

    model->setQuery(sqlQuery, db);
    return model->record(0).value(0).toInt();
}

QSqlQueryModel* Mdb::find(const QString table_name, const long id)
{
    QString sqlQuery;
    QSqlQueryModel *model = new QSqlQueryModel();

    ///Convert id from int to QString
    QString idString = QString("%1").arg(id);

    ///Construct select sql request
    sqlQuery = "select * from " +
               table_name +
               " where id ='" +
               idString +
               "'";
    ///End construct sql request
    sqlQuery +=";";

    ///Exec sql request
    model->setQuery(sqlQuery, db);
    return model;
}

/*
QSqlQueryModel* Mdb::find(const QString table_name,
                          const QVector<QString> *columnName,
                          const QVector<QString> *fieldName,
                          const QVector<QString> *fieldValue

                          )
{
    ///SqlQueryModel when we return sql request
    QSqlQueryModel *model = new QSqlQueryModel();
    int size;

    QString sqlQuery;

    return model;
}
*/

QSqlQueryModel* Mdb::find(const QString name,
                          const QVector<QString> *fieldName,
                          const QVector<QString> *fieldEquality,
                          const QVector<QString> *fieldValue,
                          const QVector<QString> *columnName)
{
    // TODO: Validate the parameters and search for sql-injections

    ///SqlQueryModel when we return sql request
    QSqlQueryModel *model = new QSqlQueryModel();
    int size;

    QString sqlQuery; //TODO:    

    ///Set count of fields in size
    size = fieldName->size();

    ///Construct select sql request
    sqlQuery = "select ";

    ///Add columns for result model
    if (columnName->size() == 0) {
        sqlQuery += "*";
    } else {
        for (int i=0; i < (columnName->size()-1); i++)
        {
            sqlQuery += columnName->at(i) + ",";
        }
        sqlQuery += columnName->at( columnName->size() - 1 );
    }

    sqlQuery += " from " + name;

    if (size>0) {
        sqlQuery +=
                " where "+
                fieldName->at(0)+
                " " +
                fieldEquality->at(0)+
                " '" +
                fieldValue->at(0)+
                "'";
    }

    ///Add second parameters to find
    for(int i = 1; i < size; i++)    {
        sqlQuery += " AND " +
                    fieldName->at(i) +
                    " " +
                    fieldEquality->at(i)+
                    " " +
                    "'" +
                    fieldValue->at(i)+
                    "'";
    }

    ///End of sql request
    sqlQuery += ";";

    qDebug() << sqlQuery;

    ///Set sql query and send request
    model->setQuery(sqlQuery, db);

    return model;
}

QSqlQueryModel* Mdb::dirty_hacked_exec(QString string)
{
    QSqlQueryModel *model = new QSqlQueryModel();

    model->setQuery(string, db);

    return model;
}

QSqlQueryModel* Mdb::find(const QString name,
                          const QVector<QString> *fieldName,
                          const QVector<QString> *fieldValue)
{
    ///SqlQueryModel when we return sql request
    QSqlQueryModel *model = new QSqlQueryModel();
    int size;

    QString sqlQuery;
    ///Set count of fields in size
    size = fieldName->size();

    ///Construct select sql request
    sqlQuery = "select * from " +
               name;

    if (size>0) {
        sqlQuery +=
                " where "+
                fieldName->at(0)+
                "='" +
                fieldValue->at(0)+
                "'";
    }

    ///Add second parameters to find
    for(int i = 1; i < size; i++)    {
        sqlQuery += " AND " +
                    fieldName->at(0) +
                    "='" +
                    fieldValue->at(0)+
                    "'";
    }

    ///End of sql request
    sqlQuery += ";";

    ///Set sql query and send request
    model->setQuery(sqlQuery, db);

    return model;
}

int Mdb::deleteFromDb(const QString name, const long id)
{
    QString sqlQuery;

    ///Convert id from int to QString
    QString idString = QString("%1").arg(id);

    ///Construct delete sql request
    sqlQuery = "delete from " + name + " where id='" + idString + "'";

    ///End construct sql request
    sqlQuery +=";";

    return this->exec(sqlQuery);
}

int Mdb::createTable(const QString name, const QVector<QString>fieldName, const QVector<QString> fieldType)
{
    //TODO: Comment !!!
    QString sqlQuery;
    int size;

    size = fieldName.size();

    sqlQuery = "create table" + name;

    sqlQuery += "(";

    for(int i = 0; i < size - 1; i++) {
        sqlQuery += fieldName.at(i) + " " + fieldType.at(i) + ",";
    }

    sqlQuery += fieldName.at(size) + " " + fieldType.at(size) + ")";
    sqlQuery += ";";

    //TODO: Error handler
    exec(sqlQuery);
    return 0;
}

int Mdb::exec(const QString sql_request)
{
    QSqlQuery query;

    ///Exec sql request
    query.exec(sql_request);

    ///Error handler for sql request
    if ( ! query.isActive() ) {
        // TODO: debug mode
        qDebug() << sql_request;
        qDebug() << "query out:" << query.lastError().text();
    }

    ///Improve sql exec status
    return query.isActive();
}

Mdb::~Mdb()
{
    ///Close database connection
    db.close();
    //    delete db;
}
