/***************************************************************************

     manager.h
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#ifndef MANAGER_H
#define MANAGER_H
/*
#include "../model/order.h"
#include "../model/good.h"
#include "../model/goodstree.h"

#include "../database/mdb.h"
*/

//#if defined(Q_OS_LINUX)
#include "src/user_interface/maemo/InformationObjects/goodinfoobject.h"
#include "src/user_interface/maemo/InformationObjects/goodsviewinfoobject.h"
#include "src/user_interface/maemo/InformationObjects/pathinfoobject.h"
#include "src/user_interface/maemo/InformationObjects/serviceinfoobject.h"
//#endif


#include <QAbstractItemModel>
#include <QStandardItemModel>
#include <QObject>

#include "demoservicelogic.h"

// TODO: enum
#define INVALID_ORDER 13
#define OK 0

/// BusinessLogic class. Contains all the business logic of the application.
/*!
 * BusinessLogic class.
 * Contains all the business logic of the application.
 * It is responsible for connecting user interface
 * to lower application layers (IO).
 */
class Manager : public QObject
{
    Q_OBJECT

private:
    DemoServiceLogic *demoMng;
public:
    /// Constructor.
    /**
     * Constructor of Manager.
     */
    Manager();

    QAbstractItemModel* getModelWithOneItem(QString string);

public slots:
    /// Handles closing the program
    /**
      * Handles the closing of program and deletes some trash data
      */
    void allClosed();

    /**
         * slot registers subscription transferred
         * object to the information on this product
         */
    void registersObjectOnGoodInfo(GoodInfoObject *goodInfoClient);
    /**
         * slot registers subscription transferred
         * object to the information on goods list
         */
    void registersObjectOnGoodViewInfo(GoodsViewInfoObject *goodViewInfoClient);
    /**
         * slot registers subscription transferred
         * object to the information on path in goods tree
         */
    void registersObjectOnPathInfo(PathInfoObject *pathInfoClient);
    /**
         * slot registers subscription transferred
         * object to the information on this product
         */
    void registersObjectOnServiceInfo(ServiceInfoObject *serviceInfoClient);
};

#endif // MANAGER_H
