/***************************************************************************

     manager.cpp
     -------------
     Copyright (c) 2010 by Andrianov Pavel <andriano@kappa.cs.karelia.ru> and Denis Zabirohin <denis.zabirokhin@gmail.com>

 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,	   *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	   *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	   *
 *   GNU General Public License for more details.			   *
 * 									   *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software	   *
 *   Foundation, Inc., 51 Franklin Street,                                 *
 *   Fifth Floor, Boston, MA  02110-1301, USA.                             *
 *                                                                         *
 ***************************************************************************/

#include "manager.h"

Manager::Manager()
{
    ///Test
    demoMng = new DemoServiceLogic();
    qDebug() << "getGoods active";
    demoMng->getGoods();
    qDebug() << "getGoodsType active";
    demoMng->getGoodTypes();
}

void Manager::allClosed()
{

}


QAbstractItemModel* Manager::getModelWithOneItem(QString string)
{
    QStandardItemModel* model = new QStandardItemModel(1,1);
    QStandardItem *item0 = new QStandardItem(string);
    model->setItem(0, 0, item0);
    return model;
}

void Manager::registersObjectOnGoodInfo(GoodInfoObject *goodInfoClient)
{
    qDebug()<<"IN REGISTERED GOODS";

    connect(goodInfoClient,SIGNAL(needsGoodsInfo(int)),demoMng,SLOT(goodSelected(int)));

    connect(demoMng,SIGNAL(goodDetailName(QString)),goodInfoClient,SIGNAL(readyGoodsNameInfo(QString)));

    connect(demoMng,SIGNAL(goodDetailTypeName(QString)),goodInfoClient,SIGNAL(readyGoodsTypeInfo(QString)));

    connect(demoMng,SIGNAL(goodDetailPrice(QString)),goodInfoClient,SIGNAL(readyGoodsPriceInfo(QString)));

    connect(demoMng,SIGNAL(goodDetailCurrency(QString)),goodInfoClient,SIGNAL(readyGoodsCurrencyInfo(QString)));

    connect(demoMng,SIGNAL(goodDetailQuantity(QString)),goodInfoClient,SIGNAL(readyGoodsQuantityInfo(QString)));

    connect(demoMng,SIGNAL(goodDetailRemain(QString)),goodInfoClient,SIGNAL(readyGoodsRemainsInfo(QString)));

    //connect(this,SIGNAL(),wnd1,SIGNAL(readyServiceLogo(QAbstractItemModel*)));
	
//	connect(goodInfoClient,SIGNAL(needsGoodsInfo(int)),this,SLOT(testSlot(int)));

  //  connect(this,SIGNAL(goodDetailName(QString)),this,SLOT(testSlot(QString)));

}

void Manager::registersObjectOnGoodViewInfo(GoodsViewInfoObject *goodViewInfoClient)
{
    qDebug()<<"IN REGISTERED GOODS VIEW";

    connect(goodViewInfoClient,SIGNAL(needGoodsTable(QString)),demoMng,SLOT(goodsFiltered(QString)));

    connect(demoMng,SIGNAL(dataReady(QAbstractItemModel*,QAbstractItemModel*)),
            goodViewInfoClient,SIGNAL(readyGoodsAndDirectory(QAbstractItemModel*,QAbstractItemModel*)));

    connect(
            demoMng,
            SIGNAL(goodsReady(QAbstractItemModel*)),
            goodViewInfoClient,
            SIGNAL(readyGoodsTable(QAbstractItemModel*))
            );

    connect(
            demoMng,
            SIGNAL(typesReady(QAbstractItemModel*)),
            goodViewInfoClient,
            SIGNAL(readyGoodsDirectory(QAbstractItemModel*))
            );



}

void Manager::registersObjectOnPathInfo(PathInfoObject *pathInfoClient)
{
    qDebug()<<"IN REGISTERED PATH INFO";

    connect(
            pathInfoClient,
            SIGNAL(needGoodsPath(int)),
            demoMng,
            SLOT(typeSelected(int))
            );

    connect(
            demoMng,
            SIGNAL(pathReady(QAbstractItemModel*)),
            pathInfoClient,
            SIGNAL(readyGoodsPath(QAbstractItemModel*))
            );

}

void Manager::registersObjectOnServiceInfo(ServiceInfoObject *serviceInfoClient)
{
    qDebug()<<"IN REGISTERED SERVICES";
//    QObject::connect(serviceInfoClient, SIGNAL(serviceSelected(int)), this, SLOT(updateGoodsFromWs(int)));
}
